% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tempGP.R
\name{tempGP}
\alias{tempGP}
\title{temporal Gaussian process}
\usage{
tempGP(
  trainX,
  trainY,
  trainT = NULL,
  fast_computation = TRUE,
  limit_memory = 5000L,
  optim_control = list(batch_size = 100L, learn_rate = 0.05, max_iter = 5000L, tol =
    1e-06, beta1 = 0.9, beta2 = 0.999, epsilon = 1e-08, logfile = NULL)
)
}
\arguments{
\item{trainX}{A matrix with each column corresponding to one input variable.}

\item{trainY}{A vector with each element corresponding to the output at the corresponding row of \code{trainX}.}

\item{trainT}{A vector for time indices of the data points. By default, the function assigns natural numbers starting from 1 as the time indices.}

\item{fast_computation}{A Boolean that specifies whether to do exact inference or fast approximation. Default is \code{TRUE}.}

\item{limit_memory}{An integer or \code{NULL}. The integer is used sample training points during prediction to limit the total memory requirement. Setting the value to \code{NULL} would result in no sampling, that is, full training data is used for prediction. Default value is \code{5000}.}

\item{optim_control}{A list parameters passed to the Adam optimizer when \code{fast_computation} is set to \code{TRUE}. The default values have been tested rigorously and tend to strike a balance between accuracy and speed. \itemize{
\item \code{batch_size}: Number of training points sampled at each iteration of Adam.
\item \code{learn_rate}: The step size for the Adam optimizer.
\item \code{max_iter}: The maximum number of iterations to be performed by Adam.
\item \code{tol}: Gradient tolerance.
\item \code{beta1}: Decay rate for the first moment of the gradient.
\item \code{beta2}: Decay rate for the second moment of the gradient.
\item \code{epsilon}: A small number to avoid division by zero.
\item \code{logfile}: A string specifying a file name to store hyperparameters value for each iteration.
}}
}
\value{
An object of class \code{tempGP} with the following attributes:
\itemize{
\item trainX - same as the input matrix \code{trainX}.
\item trainY - same as the input vector \code{trainY}.
\item thinningNumber - the thinning number computed by the algorithm.
\item modelF - A list containing the details of the model for predicting function \code{f(x)}:
\itemize{
\item X - The input variable matrix for computing the cross-covariance for predictions, same as \code{trainX} unless the model is updated. See \code{\link{updateData.tempGP}} method for details on updating the model.
\item y - The response vector, again same as \code{trainY} unless the model is updated.
\item weightedY - The weighted response, that is, the response left multiplied by the inverse of the covariance matrix.
} 
\item modelG - A list containing the details of the model for predicting function \code{g(t)}:
\itemize{
\item residuals - The residuals after subtracting function \code{f(x)} from the response. Used to predict \code{g(t)}. See \code{\link{updateData.tempGP}} method for updating the residuals.
\item time_index - The time indices of the residuals, same as \code{trainT}.
}
\item estimatedParams - Estimated hyperparameters for function \code{f(x)}.
\item llval - log-likelihood value of the hyperparameter optimization for \code{f(x)}.
\item gradval - gradient vector at the optimal log-likelihood value.
}
}
\description{
A Gaussian process based power curve model which explicitly models the temporal aspect of the power curve. The model consists of two parts: \code{f(x)} and \code{g(t)}.
}
\examples{

    data = DSWE::data1
    trainindex = 1:100 #using the first 100 data points to train the model
    traindata = data[trainindex,]
    xCol = 2 #input variable columns
    yCol = 7 #response column
    trainX = as.matrix(traindata[,xCol])
    trainY = as.numeric(traindata[,yCol])
    tempGPObject = tempGP(trainX, trainY)


}
\references{
Prakash, A., Tuo, R., & Ding, Y. (2022). "The temporal overfitting problem with applications in wind power curve modeling." Technometrics. \doi{10.1080/00401706.2022.2069158}.
}
\seealso{
\code{\link{predict.tempGP}} for computing predictions and \code{\link{updateData.tempGP}} for updating data in a tempGP object.
}
