% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSConnection.R
\name{dsIsAsync}
\alias{dsIsAsync}
\title{Asynchronous result support}
\usage{
dsIsAsync(conn)
}
\arguments{
\item{conn}{An object that inherits from \code{\link{DSConnection-class}}.}
}
\description{
When a \code{\link{DSResult-class}} object is returned on aggregation or assignment operation,
the raw result can be accessed asynchronously, allowing parallelization of DataSHIELD calls
over multpile servers. The returned named list of logicals will specify if asynchronicity is supported for:
aggregation operation ('aggregate'), table assignment operation ('assignTable'),
resource assignment operation ('assignResource') and expression assignment operation ('assignExpr').

\Sexpr[results=rd,stage=render]{DSI:::methods_as_rd("dsIsAsync")}
}
\examples{
\dontrun{
con <- dbConnect(DSOpal::Opal(), "server1",
  "username", "password", "https://opal.example.org")
dsIsAsync(con)
dsDisconnect(con)
}
}
\seealso{
Other DSConnection generics: 
\code{\link{DSConnection-class}},
\code{\link{dsAggregate}()},
\code{\link{dsAssignExpr}()},
\code{\link{dsAssignResource}()},
\code{\link{dsAssignTable}()},
\code{\link{dsDisconnect}()},
\code{\link{dsGetInfo}()},
\code{\link{dsHasResource}()},
\code{\link{dsHasTable}()},
\code{\link{dsKeepAlive}()},
\code{\link{dsListMethods}()},
\code{\link{dsListPackages}()},
\code{\link{dsListResources}()},
\code{\link{dsListSymbols}()},
\code{\link{dsListTables}()},
\code{\link{dsListWorkspaces}()},
\code{\link{dsRmSymbol}()},
\code{\link{dsRmWorkspace}()},
\code{\link{dsSaveWorkspace}()}
}
\concept{DSConnection generics}
