% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_parasites_ode.R
\name{simulate_parasites_ode}
\alias{simulate_parasites_ode}
\title{Simulation of a compartmental infectious disease transmission model illustrating 
parasite infection dynamics with intermediate hosts}
\usage{
simulate_parasites_ode(Sh = 1000, Ih = 1, E = 1, Si = 0, Ii = 0,
  tmax = 120, bi = 0.01, be = 0.01, m = 0, n = 0, g = 0,
  w = 0, p = 0.01, c = 0.001)
}
\arguments{
\item{Sh}{: initial number of susceptible definitive hosts : numeric}

\item{Ih}{: initial number of infected definitive hosts : numeric}

\item{E}{: initial number of pathogens in the environment : numeric}

\item{Si}{: initial number of susceptible intermediate hosts : numeric}

\item{Ii}{: initial number of infected intermediate hosts : numeric}

\item{tmax}{: maximum simulation time : numeric}

\item{bi}{: rate of transmission from infected intermediate host to susceptible host : numeric}

\item{be}{: rate of transmission from environment to susceptible intermediate host : numeric}

\item{m}{: the rate of births of intermediate hosts : numeric}

\item{n}{: the rate of natural intermediate hosts : numeric}

\item{g}{: the rate at which infected hosts recover/die : numeric}

\item{w}{: the rate at which host immunity wanes in host : numeric}

\item{p}{: rate at which infected host shed the pathogen in the environment : numeric}

\item{c}{: rate at which the pathogen decays in the environment : numeric}
}
\value{
This function returns the simulation result as obtained from a call
  to the deSolve ode solver.
}
\description{
This model allows for the simulation of a parasitic infection that requires 
an intermediate host for transmission
}
\details{
A compartmental ID model with several states/compartments
  is simulated as a set of ordinary differential
  equations. The function returns the output from the odesolver as a matrix,
  with one column per compartment/variable. The first column is time.
}
\section{Warning}{

  This function does not perform any error checking. So if you try to do
  something nonsensical (e.g. negative values or fractions > 1),
  the code will likely abort with an error message.
}

\examples{
  # To run the simulation with default parameters just call the function:
  result <- simulate_parasites_ode()
  # To choose parameter values other than the standard one, 
  # specify the parameters you want to change, e.g. like such:
  result <- simulate_parasites_ode(Sh = 2000, Ih = 10, tmax = 100, g = 0.5)
  # You should then use the simulation result returned from the function, like this:
  plot(result$ts[ , "time"],result$ts[ , "Sh"],xlab='Time',ylab='Number Susceptible',type='l')
}
\seealso{
The UI of the app 'Parasite Model', which is part of the DSAIDE package, contains more details.
}
\author{
Andreas Handel, Christine Casey
}
