% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ipw_did_panel.R
\name{ipw_did_panel}
\alias{ipw_did_panel}
\title{Inverse probability weighted DiD estimator, with panel data}
\usage{
ipw_did_panel(
  y1,
  y0,
  D,
  covariates,
  i.weights = NULL,
  boot = FALSE,
  boot.type = "weighted",
  nboot = NULL,
  inffunc = FALSE
)
}
\arguments{
\item{y1}{An \eqn{n} x \eqn{1} vector of outcomes from the post-treatment period.}

\item{y0}{An \eqn{n} x \eqn{1} vector of outcomes from the pre-treatment period.}

\item{D}{An \eqn{n} x \eqn{1} vector of Group indicators (=1 if observation is treated in the post-treatment, =0 otherwise).}

\item{covariates}{An \eqn{n} x \eqn{k} matrix of covariates to be used in the propensity score estimation.
If covariates = NULL, this leads to an unconditional DiD estimator.}

\item{i.weights}{An \eqn{n} x \eqn{1} vector of weights to be used. If NULL, then every observation has the same weights.}

\item{boot}{Logical argument to whether bootstrap should be used for inference. Default is FALSE.}

\item{boot.type}{Type of bootstrap to be performed (not relevant if \code{boot = FALSE}). Options are "weighted" and "multiplier".
If \code{boot = TRUE}, default is "weighted".}

\item{nboot}{Number of bootstrap repetitions (not relevant if \code{boot = FALSE}). Default is 999.}

\item{inffunc}{Logical argument to whether influence function should be returned. Default is FALSE.}
}
\value{
A list containing the following components:
\item{ATT}{The IPW DiD point estimate.}
\item{se}{ The IPW DiD standard error}
\item{uci}{Estimate of the upper bound of a 95\% CI for the ATT}
\item{lci}{Estimate of the lower bound of a 95\% CI for the ATT}
\item{boots}{All Bootstrap draws of the ATT, in case bootstrap was used to conduct inference. Default is NULL}
\item{att.inf.func}{Estimate of the influence function. Default is NULL}
 \item{call.param}{The matched call.}
 \item{argu}{Some arguments used (explicitly or not) in the call (panel = TRUE, normalized = FALSE, boot, boot.type, nboot, type="ipw")}
}
\description{
\code{ipw_did_panel} is used to compute inverse probability weighted (IPW) estimators for the ATT
 in difference-in-differences (DiD) setups with panel data. IPW weights are not normalized to sum up to one,
 that is, the estimator is of the Horwitz-Thompson type.
}
\examples{
# Form the Lalonde sample with CPS comparison group
eval_lalonde_cps <- subset(nsw, nsw$treated == 0 | nsw$sample == 2)
# Further reduce sample to speed example
set.seed(123)
unit_random <- sample(1:nrow(eval_lalonde_cps), 5000)
eval_lalonde_cps <- eval_lalonde_cps[unit_random,]
# Select some covariates
covX = as.matrix(cbind(eval_lalonde_cps$age, eval_lalonde_cps$educ,
                             eval_lalonde_cps$black, eval_lalonde_cps$married,
                             eval_lalonde_cps$nodegree, eval_lalonde_cps$hisp,
                             eval_lalonde_cps$re74))
# Implement (unnormalized) IPW DiD with panel data
ipw_did_panel(y1 = eval_lalonde_cps$re78, y0 = eval_lalonde_cps$re75,
                D = eval_lalonde_cps$experimental,
                covariates = covX)

}
\references{
\cite{Abadie, Alberto (2005), "Semiparametric Difference-in-Differences Estimators",
Review of Economic Studies, vol. 72(1), p. 1-19, \doi{10.1111/0034-6527.00321}}


\cite{Sant'Anna, Pedro H. C. and Zhao, Jun. (2020),
"Doubly Robust Difference-in-Differences Estimators." Journal of Econometrics, Vol. 219 (1), pp. 101-122,
\doi{10.1016/j.jeconom.2020.06.003}}
}
