% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StatFunctions.R
\name{pooledVarDP}
\alias{pooledVarDP}
\title{Differentially Private Pooled Variance}
\usage{
pooledVarDP(
  ...,
  eps = 1,
  lower.bound,
  upper.bound,
  which.sensitivity = "bounded",
  mechanism = "Laplace",
  delta = 0,
  type.DP = "aDP",
  approx.n.max = FALSE
)
}
\arguments{
\item{...}{Two or more vectors from which to compute the pooled variance.}

\item{eps}{Positive real number defining the epsilon privacy budget.}

\item{lower.bound}{Real number giving the global or public lower bound of the
input data.}

\item{upper.bound}{Real number giving the global or public upper bound of the
input data.}

\item{which.sensitivity}{String indicating which type of sensitivity to use.
Can be one of {'bounded', 'unbounded', 'both'}. If 'bounded' (default),
returns result based on bounded definition for differential privacy. If
'unbounded', returns result based on unbounded definition. If 'both',
returns result based on both methods \insertCite{Kifer2011}{DPpack}. Note
that if 'both' is chosen, each result individually satisfies (eps,
delta)-differential privacy, but may not do so collectively and in
composition. Care must be taken not to violate differential privacy in this
case.}

\item{mechanism}{String indicating which mechanism to use for differential
privacy. Currently the following mechanisms are supported: {'Laplace',
'Gaussian'}. Default is Laplace. See \code{\link{LaplaceMechanism}} and
\code{\link{GaussianMechanism}} for a description of the supported
mechanisms.}

\item{delta}{Nonnegative real number defining the delta privacy parameter. If
0 (default), reduces to eps-DP and the Laplace mechanism is used.}

\item{type.DP}{String indicating the type of differential privacy desired for
the Gaussian mechanism (if selected). Can be either 'pDP' for probabilistic
DP \insertCite{Machanavajjhala2008}{DPpack} or 'aDP' for approximate DP
\insertCite{Dwork2006b}{DPpack}. Note that if 'aDP' is chosen, epsilon must
be strictly less than 1.}

\item{approx.n.max}{Logical indicating whether to approximate n.max (defined
to be the length of the largest input vector) in the computation of the
global sensitivity based on the upper and lower bounds of the data
\insertCite{Liu2019b}{DPpack}. Approximation is best if n.max is very
large.}
}
\value{
Sanitized pooled variance based on the bounded and/or unbounded
definitions of differential privacy.
}
\description{
This function computes the differentially private pooled variance from two or
more vectors of data at user-specified privacy levels of epsilon and delta.
}
\examples{
# Build datasets
D1 <- stats::rnorm(500, mean=3, sd=2)
D2 <- stats::rnorm(200, mean=3, sd=2)
D3 <- stats::rnorm(100, mean=3, sd=2)
lower.bound <- -3 # 3 standard deviations below mean
upper.bound <- 9 # 3 standard deviations above mean

# Get private pooled variance without approximating n.max
private.pooled.var <- pooledVarDP(D1, D2, D3, eps=1, lower.bound=lower.bound,
                                  upper.bound = upper.bound)
private.pooled.var

# If n.max is sensitive, we can also use
private.pooled.var <- pooledVarDP(D1, D2, D3, eps=1, lower.bound=lower.bound,
                                  upper.bound = upper.bound,
                                  approx.n.max = TRUE)
private.pooled.var

}
\references{
\insertRef{Dwork2006a}{DPpack}

\insertRef{Kifer2011}{DPpack}

\insertRef{Machanavajjhala2008}{DPpack}

\insertRef{Dwork2006b}{DPpack}

\insertRef{Liu2019b}{DPpack}
}
