% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StatFunctions.R
\name{tableDP}
\alias{tableDP}
\title{Differentially Private Contingency Table}
\usage{
tableDP(
  ...,
  eps = 1,
  which.sensitivity = "bounded",
  mechanism = "Laplace",
  delta = 0,
  type.DP = "aDP",
  allow.negative = FALSE
)
}
\arguments{
\item{...}{Vectors of data from which to create the contingency table.}

\item{eps}{Positive real number defining the epsilon privacy budget.}

\item{which.sensitivity}{String indicating which type of sensitivity to use.
Can be one of {'bounded', 'unbounded', 'both'}. If 'bounded' (default),
returns result based on bounded definition for differential privacy. If
'unbounded', returns result based on unbounded definition. If 'both',
returns result based on both methods \insertCite{Kifer2011}{DPpack}. Note
that if 'both' is chosen, each result individually satisfies (eps,
delta)-differential privacy, but may not do so collectively and in
composition. Care must be taken not to violate differential privacy in this
case.}

\item{mechanism}{String indicating which mechanism to use for differential
privacy. Currently the following mechanisms are supported: {'Laplace',
'Gaussian'}. Default is Laplace. See \code{\link{LaplaceMechanism}} and
\code{\link{GaussianMechanism}} for a description of the supported
mechanisms.}

\item{delta}{Nonnegative real number defining the delta privacy parameter. If
0 (default), reduces to eps-DP and the Laplace mechanism is used.}

\item{type.DP}{String indicating the type of differential privacy desired for
the Gaussian mechanism (if selected). Can be either 'pDP' for probabilistic
DP \insertCite{Machanavajjhala2008}{DPpack} or 'aDP' for approximate DP
\insertCite{Dwork2006b}{DPpack}. Note that if 'aDP' is chosen, epsilon must
be strictly less than 1.}

\item{allow.negative}{Logical value. If FALSE (default), any negative values
in the sanitized table due to the added noise will be set to 0. If TRUE,
the negative values (if any) will be returned.}
}
\value{
Sanitized contingency table based on the bounded and/or unbounded
definitions of differential privacy.
}
\description{
This function computes a differentially private contingency table from given
vectors of data at user-specified privacy levels of epsilon and delta.
}
\examples{
x <- MASS::Cars93$Type
y <- MASS::Cars93$Origin
z <- MASS::Cars93$AirBags
tableDP(x,y,eps=1,which.sensitivity='bounded',mechanism='Laplace',
  type.DP='pDP')
tableDP(x,y,z,eps=.5,which.sensitivity='unbounded',mechanism='Gaussian',
  delta=0.01)

}
\references{
\insertRef{Dwork2006a}{DPpack}

\insertRef{Kifer2011}{DPpack}

\insertRef{Machanavajjhala2008}{DPpack}

\insertRef{Dwork2006b}{DPpack}
}
