% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dgm.R
\name{reshapeTs}
\alias{reshapeTs}
\title{Reshapes a 2D concatenated time series into 3D according to no. of subjects and volumes.}
\usage{
reshapeTs(ts, N, V)
}
\arguments{
\item{ts}{a 2D time series volumes x nodes.}

\item{N}{No. of subjects.}

\item{V}{No. of volumes.}
}
\value{
M 3D matrix, time series x nodes x subjects.
}
\description{
Reshapes a 2D concatenated time series into 3D according to no. of subjects and volumes.
}
\examples{
# Let's say subjects are concatenated in a 2D matrix
# (samples x nodes), with each having 200 samples.
# generate some sample data
N=20
Nn=5
x = array(rnorm(200*N*Nn), dim=c(200*N,Nn))
ts = reshapeTs(x,N,200)

}
