% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init.R
\name{initDGEobj}
\alias{initDGEobj}
\title{Initialize with base data (primaryAssayData, row annotations, col annotations)}
\usage{
initDGEobj(
  primaryAssayData,
  rowData,
  colData,
  level,
  customAttr,
  allowShortSampleIDs = FALSE,
  DGEobjDef = initDGEobjDef()
)
}
\arguments{
\item{primaryAssayData}{A numeric matrix or dataframe with row and
colnames. Each column represents a sample.  Each row represents and assay.
This is typically the counts matrix in a DGE RNA-Seq experiment.}

\item{rowData}{Gene, isoform or exon level annotation. Rownames
must match the rownames in primaryAssayData}

\item{colData}{A dataframe describing the experiment design.
Rownames much match the colnames(primaryAssayData)}

\item{level}{One of "gene", "isoform", or "exon"}

\item{customAttr}{(optional) Named list of attributes}

\item{allowShortSampleIDs}{Using sequential integer rownames (even if typed
as character) is discouraged and by default will abort the DGEobj creation.
If you have a legitimate need to have short sample names composed of
numeric characters, you can set this argument to TRUE (default = FALSE)}

\item{DGEobjDef}{An object definition. Defaults to the global
DGEobj definition (initDGEobjDef()) and you usually shouldn't change this unless
you're customizing the object for new data types.}
}
\value{
A DGEobj
}
\description{
Initialize with base data (primaryAssayData, row annotations, col annotations)
}
\examples{

   dgeObj <- readRDS(system.file("exampleObj.RDS", package = "DGEobj"))
   MyCounts <- dgeObj$counts
   geneinfo <- dgeObj$geneData
   sampinfo <- dgeObj$design

  myDgeObj <- initDGEobj(primaryAssayData = MyCounts,
                         rowData = geneinfo,
                         colData = sampinfo,
                         level = "gene",
                         customAttr = list (Genome = "Rat.B6.0",
                                            GeneModel = "Ensembl.R89"))

}
