% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotate.R
\name{annotateDGEobj}
\alias{annotateDGEobj}
\title{Add annotations}
\usage{
annotateDGEobj(dgeObj, annotations, keys = NULL)
}
\arguments{
\item{dgeObj}{A class DGEobj created by function initDGEobj()}

\item{annotations}{Either A character string path to a file with annotations given as key/value pairs separated by an equal sign, or a named list of key/value pairs}

\item{keys}{A subset of keys to look for in the annotations and transfer to the DGEobj (default = NULL)}
}
\value{
A DGEobj
}
\description{
Reads an annotation file of key/value pairs or a named list and attaches them attributes to a DGEobj.
If a file is used, it should be a text file containing key/value pairs separated by an equals
sign. The keys parameter specifies which key we want to capture as
attributes on the DGEobj. The value will then be the value of that attribute.
}
\examples{
\dontrun{
   MyDgeObj <- annotateDGEobj(DGEobj, annotations)
}

}
