% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DEploidR.R
\name{histWSAF}
\alias{histWSAF}
\title{WSAF histogram}
\usage{
histWSAF(obsWSAF, exclusive = TRUE, title = "Histogram 0<WSAF<1",
  cex.lab = 1, cex.main = 1, cex.axis = 1)
}
\arguments{
\item{obsWSAF}{Observed allele frequency within sample}

\item{exclusive}{When TRUE 0 < WSAF < 1; otherwise 0 <= WSAF <= 1.}

\item{title}{Histogram title}

\item{cex.lab}{Label size.}

\item{cex.main}{Title size.}

\item{cex.axis}{Axis text size.}
}
\value{
histogram
}
\description{
Produce histogram of the allele frequency within sample.
}
\examples{
# Example 1
refFile = system.file("extdata", "PG0390-C.test.ref", package = "DEploid")
altFile = system.file("extdata", "PG0390-C.test.alt", package = "DEploid")
PG0390Coverage = extractCoverageFromTxt(refFile, altFile)
obsWSAF = computeObsWSAF(PG0390Coverage$altCount, PG0390Coverage$refCount)
histWSAF(obsWSAF)
myhist = histWSAF(obsWSAF, FALSE)

# Example 2
vcfFile = system.file("extdata", "PG0390-C.test.vcf.gz", package = "DEploid")
PG0390CoverageV = extractCoverageFromVcf(vcfFile)
obsWSAF = computeObsWSAF(PG0390CoverageV$altCount, PG0390CoverageV$refCount)
histWSAF(obsWSAF)
myhist = histWSAF(obsWSAF, FALSE)

}
