% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DELTD.R
\name{plot.LogN}
\alias{plot.LogN}
\title{Density Plot by Lognormal kernel}
\usage{
\method{plot}{LogN}(x, ...)
}
\arguments{
\item{x}{An object of class "LogN"}

\item{\dots}{Not presently used in this implementation}
}
\value{
Nothing
}
\description{
Plot Kernel density by using Lognormal Kernel.
}
\examples{
n <- 1000
y <- abs(rlogis(n, location = 0, scale = 1))
xx <- seq(min(y) + 0.05, max(y), length =90)
h <- 0.00003
den <- LogN(x = xx, y = y, k = 90, h = h)
plot(den, type = "l")

##other details can also be added
y <- abs(rlogis(n, location = 0, scale = 1))
h <- 3
gr <- LogN(x = xx, y = y, k = 90, h = h)
plot(gr, type = "s", ylab = "Density Function", lty = 1, xlab = "Time")

## To add true density along with estimated
d1 <- density(y, bw = h)
lines(d1, type = "p", col = "green")
legend("topleft", c("Real Density", "Density by Lognormal Kernel"),
col = c("green", "black"), lty = c(1,2))
}
\references{
Jin, X.; Kawczak, J. 2003. Birnbaum-Saunders & Lognormal kernel estimators for modeling durations in high frequency financial data. \emph{Annals of Economics and Finance} \strong{4}, 103-124.
}
\seealso{
For further kernels see \code{\link{plot.Beta}}, \code{\link{plot.Erlang}}, \code{\link{plot.Gamma}} and \code{\link{plot.BS}}. To calculate MSE use \code{\link{mse}} and for estimated values for density
estimation see \code{\link{LogN}}.
}
\author{
Javaria Ahmad Khan, Atif Akbar.
}
