% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DELTD.R
\name{Erlang}
\alias{Erlang}
\title{Estimated Density Values by Erlang kernel}
\usage{
Erlang(y, k, h)
}
\arguments{
\item{y}{a numeric vector of positive values.}

\item{k}{gird points.}

\item{h}{the bandwidth}
}
\value{
\item{x}{grid points}
        \item{y}{estimated values of density}
}
\description{
Estimated values for density by using Erlang Kernel.
}
\details{
Erlang kernel is developed by Salha et al. (2014). They developed this asymmetrical kernal with its hazard function and also
proved its asymtotic normality.
\deqn{K_{E(x,\frac{1}{h})}  (y)=\frac{1}{\Gamma (1+\frac{1}{h})} \left[\frac{1}{x} (1+\frac{1}{h}) \right]^\frac{h+1}{h} y^\frac{1}{h} exp\left(-\frac{y}{x} (1+\frac{1}{h}) \right)}
}
\examples{
y <- rexp(100,1)
h <- 0.79 * IQR(y) * length(y) ^ (-1/5)
Erlang(y,200,h)
}
\references{
Salha, R. B.; Ahmed, E. S.; Alhoubi, I. M. 2014. Hazard rate function estimation ksing Erlang Kernel. \emph{Pure Mathematical Sciences} \strong{3} (4), 141–152.
}
\seealso{
For further MSE by using other kernels see \code{\link{BS}}, \code{\link{Gamma}} and \code{\link{LN}}. For plotting these estimated values \code{\link{plot.Erlang}} and for calculating MSE by using Erlang Kernel \code{\link{mseEr}}.
}
\author{
Javaria Ahmad Khan, Atif Akbar.
}
