% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DEET_enrich_genesonly.R
\name{DEET_enrich_genesonly}
\alias{DEET_enrich_genesonly}
\title{DEET_enrich_genesonly}
\usage{
DEET_enrich_genesonly(
  DEG_list,
  DEET_dataset,
  ordered = FALSE,
  background = NULL
)
}
\arguments{
\item{DEG_list}{Data frame or matrix of gene symbols with corresponding padj
and log2FC values (3 columns in total). Can also be a character vector of
gene symbols only. colnames of genes: c("gene_symbol", "padj", "coef")
The rownames of the dataframe are also the gene symbols.}

\item{DEET_dataset}{The databank of the differential expression enrichment tool.
Appropriate inputs here are "DEET_example_data" stored within DEET, the "DEET_combined.rda" file
from the DEET stable repositoy found at X, and the DEET database developmental repository found at Y.
The DEET_dataset is a named list where details of it's structure can be found ?DEET_example_data.
Unlike in DEET_enrich, this dataset does not require the pathway-relevant elements
of the DEET_dataset list, namely "gmt_BP", or "gmt_TF" "DEET_gmt_BP",  "DEET_gmt_TF".}

\item{ordered}{Boolean value specifying whether DEG_list is a character
vector of gene symbols that is ordered. Default value is FALSE.}

\item{background}{Character vector of human gene symbols showing all
possible genes. Default value is NULL.}
}
\value{
Named list where each element contains 2 objects. Each object will
contain the results (enrichment or correlation) and corresponding metadata.
\itemize{
  \item AP_DEET_DE_output  - Enrichment of input gene list on DEETs studies.
  \item DE_correlations    - Correlation values of input gene list to DEETs
  studies (both Pearson and Spearman).
}
}
\description{
Altered version of the  function of DEET where 
an input weighted human gene list will be queried to DEETs 
library of studies. This version does not include pathway 
enrichments.
}
\examples{

data("example_DEET_enrich_input")
data("DEET_example_data")
DEET_out <- DEET_enrich_genesonly(example_DEET_enrich_input, DEET_dataset = DEET_example_data)


}
\references{
Paczkowska M, Barenboim J, Sintupisut N, et al. Integrative pathway
enrichment analysis of multivariate omics data. Nat Commun. 2020;11(1):735.
doi:10.1038/s41467-019-13983-9
}
\author{
Dustin Sokolowski, Jedid Ahn
}
