% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dcem_init_mv.R
\name{cov_mv}
\alias{cov_mv}
\title{cov_mv: Part of DCEM package.}
\usage{
cov_mv(num_cov, numcol)
}
\arguments{
\item{num_cov}{(numeric): Number of covariance matrices corresponding to the cluster(s).}

\item{numcol}{(numeric): The number of columns in the dataset.}
}
\value{
A list of identity matrices. The number of entries in the list
        is equal to the input parameter (num_cov).

        The elements of the list can be accessed as - list[[1]] or list[[2]].
}
\description{
Initializes the co-variance matrices as the identity matrices for the Gaussian(s).
The list will simply contain one co-variance matrix per Gaussian. If the user specifies 3 cluster(s) then
there will be 3 entries in the list.
}
\details{
The dimensions of each matrix will be numcol * numcol where numcol is the number of columns in the
dataset.
}
\examples{
# Genrating the Identity matrix as the co-variance matrix.

cov_mv(2, 3)
cov_mv(10, 100)

}
\author{
Parichit Sharma \email{parishar@iu.edu}, Hasan Kurban, Mark Jenne, Mehmet Dalkilic

This work is partially supported by NCI Grant 1R01CA213466-01.
}
