% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBDriver.R, R/DBConnection.R, R/ANSI.R,
%   R/DBResult.R, R/data.R, R/deprecated.R, R/hidden.R, R/interpolate.R,
%   R/quote.R, R/table-create.R, R/table-insert.R, R/table.R, R/transactions.R
\docType{methods}
\name{dbDriver,character-method}
\alias{dbDriver,character-method}
\alias{show,DBIDriver-method}
\alias{dbDataType,DBIObject-method}
\alias{show,DBIConnection-method}
\alias{dbSendStatement,DBIConnection,character-method}
\alias{dbGetQuery,DBIConnection,character-method}
\alias{dbExecute,DBIConnection,character-method}
\alias{dbReadTable,DBIConnection,character-method}
\alias{show,AnsiConnection-method}
\alias{show,DBIResult-method}
\alias{dbFetch,DBIResult-method}
\alias{dbGetInfo,DBIResult-method}
\alias{sqlData,DBIConnection-method}
\alias{make.db.names,DBIObject,character-method}
\alias{isSQLKeyword,DBIObject,character-method}
\alias{SQLKeywords,DBIObject-method}
\alias{SQLKeywords,missing-method}
\alias{hidden_aliases}
\alias{sqlInterpolate,DBIConnection-method}
\alias{sqlParseVariables,DBIConnection-method}
\alias{show,SQL-method}
\alias{dbQuoteIdentifier,DBIConnection,character-method}
\alias{dbQuoteIdentifier,DBIConnection,SQL-method}
\alias{dbQuoteString,DBIConnection,character-method}
\alias{dbQuoteString,DBIConnection,SQL-method}
\alias{sqlCreateTable,DBIConnection-method}
\alias{sqlAppendTable,DBIConnection-method}
\alias{dbQuoteIdentifier,DBIConnection,Table-method}
\alias{show,Table-method}
\alias{dbWithTransaction,DBIConnection-method}
\title{Internal page for hidden aliases}
\usage{
\S4method{dbDriver}{character}(drvName, ...)

\S4method{show}{DBIDriver}(object)

\S4method{dbDataType}{DBIObject}(dbObj, obj, ...)

\S4method{show}{DBIConnection}(object)

\S4method{dbSendStatement}{DBIConnection,character}(conn, statement, ...)

\S4method{dbGetQuery}{DBIConnection,character}(conn, statement, ...)

\S4method{dbExecute}{DBIConnection,character}(conn, statement, ...)

\S4method{dbReadTable}{DBIConnection,character}(conn, name, ...,
  row.names = NA, check.names = TRUE)

\S4method{show}{AnsiConnection}(object)

\S4method{show}{DBIResult}(object)

\S4method{dbFetch}{DBIResult}(res, n = -1, ...)

\S4method{dbGetInfo}{DBIResult}(dbObj, ...)

\S4method{sqlData}{DBIConnection}(con, value, row.names = NA, ...)

\S4method{make.db.names}{DBIObject,character}(dbObj, snames,
  keywords = .SQL92Keywords, unique = TRUE, allow.keywords = TRUE, ...)

\S4method{isSQLKeyword}{DBIObject,character}(dbObj, name,
  keywords = .SQL92Keywords, case = c("lower", "upper", "any")[3], ...)

\S4method{SQLKeywords}{DBIObject}(dbObj, ...)

\S4method{SQLKeywords}{missing}(dbObj, ...)

\S4method{sqlInterpolate}{DBIConnection}(conn, sql, ..., .dots = list())

\S4method{sqlParseVariables}{DBIConnection}(conn, sql, ...)

\S4method{show}{SQL}(object)

\S4method{dbQuoteIdentifier}{DBIConnection,character}(conn, x, ...)

\S4method{dbQuoteIdentifier}{DBIConnection,SQL}(conn, x, ...)

\S4method{dbQuoteString}{DBIConnection,character}(conn, x, ...)

\S4method{dbQuoteString}{DBIConnection,SQL}(conn, x, ...)

\S4method{sqlCreateTable}{DBIConnection}(con, table, fields, row.names = NA,
  temporary = FALSE, ...)

\S4method{sqlAppendTable}{DBIConnection}(con, table, values, row.names = NA,
  ...)

\S4method{dbQuoteIdentifier}{DBIConnection,Table}(conn, x, ...)

\S4method{show}{Table}(object)

\S4method{dbWithTransaction}{DBIConnection}(conn, code)
}
\arguments{
\item{object}{Object to display}

\item{conn, x}{Connection and Table used when escaping.}

\item{object}{Object to display}

\item{object}{Object to display}

\item{object}{Table object to print}
}
\description{
For S4 methods that require a documentation entry but only clutter the index.
}
\keyword{internal}
