% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpolate.R
\docType{methods}
\name{sqlInterpolate}
\alias{sqlInterpolate}
\alias{sqlInterpolate,DBIConnection-method}
\title{Safely interpolate values into an SQL string.}
\usage{
sqlInterpolate(`_con`, `_sql`, ...)

\S4method{sqlInterpolate}{DBIConnection}(`_con`, `_sql`, ...)
}
\arguments{
\item{_con}{A database connection.}

\item{...}{Named values to interpolate into string. All strings
will be first escaped with \code{\link[DBI]{dbQuoteString}} prior
to interpolation to protect against SQL interpolation attacks.}

\item{`_sql`}{A SQL string containing containing variables to interpolate.
Variables must start with a question mark and can be any valid R
identifier, i.e. it must start with a letter or \code{.}, and be followed
by a letter, digit, \code{.} or \code{_}.}
}
\description{
Safely interpolate values into an SQL string.
}
\section{Backend authors}{

If you are implementing a SQL backend with non-ANSI quoting rules, you'll
need to implement a method for \code{\link{sqlParseVariables}}. Failure to
do so does not expose you to SQL injection attacks, but will (rarely) result
in errors matching supplied and interpolated variables.
}
\examples{
sql <- "SELECT * FROM X WHERE name = ?name"
sqlInterpolate(ANSI(), sql, name = "Hadley")
# This is safe because the single quote has been double escaped
sqlInterpolate(ANSI(), sql, name = "H'); DROP TABLE--;")
}

