% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hmmclustering.R
\name{model.ll}
\alias{model.ll}
\title{Get HMM Log Likelihood}
\usage{
model.ll(hmm)
}
\arguments{
\item{hmm}{An \code{hmm} object (see \code{\link[seqHMM]{build_hmm}}).}
}
\value{
The log likelihood of the \code{hmm} object, print warning if model
  is infeasible (i.e., if the log likelihood is evaluated for a sequence that
  contains emissions that are assigned probability 0 in the \code{hmm}
  object).
}
\description{
Get the log likelihood of an HMM object and check if it is feasible (i.e.,
contains no illegal emissions). Auxiliary function used in
\code{\link{partition.bic}}.
}
\seealso{
Used in \code{\link{partition.bic}}.
}
