% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_explainer.R
\name{predict.explainer}
\alias{predict.explainer}
\title{Calculate Predictions for Explainer}
\usage{
\method{predict}{explainer}(object, newdata, ...)
}
\arguments{
\item{object}{a model to be explained, object of the class \code{explainer}}

\item{newdata}{data.frame or matrix - observations for prediction}

\item{...}{other parameters that will be passed to the predict function}
}
\value{
An numeric matrix of predictions
}
\description{
This is a generic \code{predict()} function works for \code{explainer} objects.
}
\examples{
HR_glm_model <- glm(status == "fired"~., data = HR, family = "binomial")
explainer_glm <- explain(HR_glm_model, data = HR)
predict(explainer_glm, HR[1:3,])

 \dontrun{
library("randomForest")
HR_rf_model <- randomForest(status == "fired" ~., data = HR)
explainer_rf  <- explain(HR_rf_model, data = HR)
predict(explainer_rf, HR[1:3,])
 }
}
