% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_single_prediction.R
\name{plot.single_prediction_explainer}
\alias{plot.single_prediction_explainer}
\title{Plots Local Explanations (Single Prediction)}
\usage{
\method{plot}{single_prediction_explainer}(x, ..., add_contributions = TRUE,
  vcolors = c(`-1` = "#d8b365", `0` = "#f5f5f5", `1` = "#5ab4ac", X =
  "darkgrey"), digits = 3, rounding_function = round)
}
\arguments{
\item{x}{a single prediction exlainer produced with the 'single_prediction' function}

\item{...}{other explainers that shall be plotted together}

\item{add_contributions}{shall variable contributions to be added on plot?}

\item{vcolors}{named vector with colors}

\item{digits}{number of decimal places (round) or significant digits (signif) to be used.
See the \code{rounding_function} argument}

\item{rounding_function}{function that is to used for rounding numbers.
It may be \code{signif()} which keeps a specified number of significant digits.
Or the default \code{round()} to have the same precision for all components}
}
\value{
a ggplot2 object
}
\description{
Function 'plot.single_prediction_explainer' plots break down plots for a single prediction.
}
\examples{
\dontrun{
library("breakDown")
new.wine <- data.frame(citric.acid = 0.35,
     sulphates = 0.6,
     alcohol = 12.5,
     pH = 3.36,
     residual.sugar = 4.8)

wine_lm_model4 <- lm(quality ~ pH + residual.sugar + sulphates + alcohol, data = wine)
wine_lm_explainer4 <- explain(wine_lm_model4, data = wine, label = "model_4v")
wine_lm_predict4 <- single_prediction(wine_lm_explainer4, observation = new.wine)
plot(wine_lm_predict4)

library("randomForest")
wine_rf_model4 <- randomForest(quality ~ pH + residual.sugar + sulphates + alcohol, data = wine)
wine_rf_explainer4 <- explain(wine_rf_model4, data = wine, label = "model_rf")
wine_rf_predict4 <- single_prediction(wine_rf_explainer4, observation = new.wine)
plot(wine_rf_predict4)

# both models
plot(wine_rf_predict4, wine_lm_predict4)

library("gbm")
# create a gbm model
model <- gbm(quality ~ pH + residual.sugar + sulphates + alcohol, data = wine,
             distribution = "gaussian",
             n.trees = 1000,
             interaction.depth = 4,
             shrinkage = 0.01,
             n.minobsinnode = 10,
             verbose = FALSE)
 # make an explainer for the model
 explainer_gbm <- explain(model, data = wine)
 # create a new observation
 exp_sgn <- single_prediction(explainer_gbm, observation = new.wine,
              n.trees = 1000)
 exp_sgn
 plot(exp_sgn)
 plot(wine_rf_predict4, wine_lm_predict4, exp_sgn)
 }

}
