% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.heuristics.SpearmanHeuristic.R
\name{SpearmanHeuristic}
\alias{SpearmanHeuristic}
\title{Feature-clustering based on Spearman Correlation Test.}
\description{
Performs the feature-clustering using Spearman's rho statistic.
}
\details{
Spearman's rho statistic is to estimate a rank-based measure of
association. These tests may be used if the data do not necessarily come from
a bivariate normal distribution.
}
\seealso{
\code{\link{Dataset}}, \code{\link[stats]{cor.test}}
}
\keyword{cluster}
\keyword{manip}
\section{Super class}{
\code{\link[D2MCS:GenericHeuristic]{D2MCS::GenericHeuristic}} -> \code{SpearmanHeuristic}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{SpearmanHeuristic$new()}}
\item \href{#method-heuristic}{\code{SpearmanHeuristic$heuristic()}}
\item \href{#method-clone}{\code{SpearmanHeuristic$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates a \link{SpearmanHeuristic} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SpearmanHeuristic$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-heuristic"></a>}}
\if{latex}{\out{\hypertarget{method-heuristic}{}}}
\subsection{Method \code{heuristic()}}{
Test for correlation between paired samples using Spearman
rho statistic.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SpearmanHeuristic$heuristic(col1, col2, column.names = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{col1}}{A \link{numeric} vector or matrix required to perform the
clustering operation.}

\item{\code{col2}}{A \link{numeric} vector or matrix to perform the clustering
operation.}

\item{\code{column.names}}{An optional \link{character} vector with the names of
both columns.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \link{numeric} vector of length 1 or \link{NA} if an error
occurs.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SpearmanHeuristic$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
