% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_functions.R
\name{helper_functions}
\alias{helper.filter_names_to_ids}
\alias{helper.filter_names_to_ids_from_df}
\alias{helper.print_ids_names}
\alias{helper_functions}
\title{Helper Functions}
\usage{
helper.filter_names_to_ids(ids_names_list, names_array = c("*"))

helper.filter_names_to_ids_from_df(ids_names_df, names_array = c("*"))

helper.print_ids_names(ids_names_list, key = NA, reverse = FALSE)
}
\arguments{
\item{ids_names_list}{list of lists containing both IDs and their associated names}

\item{names_array}{vector or list of character regular expressions to use}

\item{ids_names_df}{dataframe containing both IDs and their associated names}

\item{key}{character representing a key to sort by, specify one of the following: ("id", "name")}

\item{reverse}{boolean to sort in descending order instead of ascending}
}
\description{
Various helper functions to utilize within the Cytobank API.
}
\details{
\code{helper.filter_names_to_ids} Compile a vector of IDs from an array of regular expressions.

\code{helper.filter_names_to_ids_from_df} Compile a vector of IDs from an array of regular expressions.

\code{helper.print_ids_names_list} Print a list of IDs and their associated names. Optional ability to sort based off of IDs or names.
}
\examples{
\donttest{helper.filter_to_ids(ids_and_names_list, names_list=c("CD.*", "Time", "pp38"))
}
\donttest{helper.filter_names_to_ids_from_df(id_and_names_dataframe, names_list=c("CD.*", "Time", "pp38"))
}
\donttest{# Print IDs and associated names as is
helper.print_ids_names_list(arbitrary_endpoint_ids_names_list)
# Print IDs and associated names, sorted by ID, in descending order
helper.print_ids_names_list(arbitrary_endpoint_ids_names_list, key="id", reverse=TRUE)
}
}

