/*
 * Decompiled with CFR 0.152.
 */
package org.mutoss.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.JTextComponent;
import org.af.commons.io.FileTransfer;
import org.af.commons.widgets.HTMLPaneWithButtons;
import org.af.commons.widgets.RightClickTextMenuListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mutoss.config.Configuration;
import org.mutoss.gui.CrossoverGUI;
import org.mutoss.gui.Design;
import org.mutoss.gui.RControl;

public class HTMLOutputPane
extends JPanel
implements ActionListener {
    private static final Log logger = LogFactory.getLog(HTMLOutputPane.class);
    protected static final long serialVersionUID = 1L;
    protected HTMLPaneWithButtons textArea;
    protected JScrollPane scrollPane;
    protected RControl rctrl;
    protected DefaultStyledDocument doc;
    CrossoverGUI gui;

    public HTMLOutputPane(CrossoverGUI gui) {
        this.gui = gui;
        this.makeComponents();
        this.textArea.addMouseListener((MouseListener)new RightClickTextMenuListener((JTextComponent)this.textArea));
        this.textArea.setEditable(true);
        this.doTheLayout();
    }

    public void clear() {
        this.textArea.clear();
    }

    public void showDesign(Design design) {
        this.textArea.clear();
        this.textArea.appendParagraph(this.textArea.makeBold(design.title + " (" + design.getRSignature() + ")"));
        this.textArea.appendParagraph("");
        this.textArea.appendHTML(design.getHTMLTable());
        this.textArea.appendParagraph("<b>Av.eff.trt.pair.adj:</b> " + CrossoverGUI.df.format(design.getEff(this.gui.getModel(), this.gui.getParam())));
        if (design.reference != null) {
            this.textArea.appendParagraph(this.textArea.makeBold("Reference: ") + "<i>" + design.reference.replaceAll("\\n", "<br>") + "</i>");
        }
        this.textArea.appendParagraph(this.getGeneralCarryover(design));
    }

    private String getGeneralCarryover(Design design) {
        String result = "<p><b>Model:</b> " + this.gui.jCBmodel.getSelectedItem() + "<br></p>";
        if (!design.isEstimable(this.gui.getModel())) {
            result = result + "<b style=\"color:red\"> Design does not allow to estimate all treatment differences under this model. </b>";
        } else {
            String command = "Crossover:::getDesignText(" + design.uniqueName + ", model=" + this.gui.getModel() + ", type=\"" + Configuration.getInstance().getProperty("outputF", "HTML") + "\"" + ", carryover=" + (Boolean.parseBoolean(Configuration.getInstance().getProperty("showCarryOver", "false")) ? "TRUE" : "FALSE") + ", digits=" + Configuration.getInstance().getGeneralConfig().getDigits() + ", names=" + (Boolean.parseBoolean(Configuration.getInstance().getProperty("showNames", "true")) ? "TRUE" : "FALSE") + (this.gui.jCBmodel.getSelectedIndex() == 3 ? ", model.param=list(placebos=" + this.gui.jtfParam.getText() + ")" : "") + (this.gui.jCBmodel.getSelectedIndex() == 2 ? ", model.param=list(ppp=" + this.gui.jtfParam.getText() + ")" : "") + ")";
            result = result + RControl.getR().eval(command).asRChar().getData()[0];
        }
        return result;
    }

    public void showError(Throwable e) throws BadLocationException, IOException {
        int i;
        String tok;
        String s = e.getMessage();
        if (s.startsWith(tok = "af.statguitoolkit.rinterface.exceptions.REvalException: ") && (i = (s = s.substring(tok.length())).indexOf(":")) != -1) {
            s = this.textArea.makeBoldItalics(s.substring(i + 2)) + "(" + s.substring(0, i) + ")";
        }
        this.textArea.appendParagraph(this.textArea.makeBold("Error: ") + this.textArea.makeBoldItalics(s));
    }

    private String makeTable2FormatButton(String imageName, String label, ActionListener al) {
        String imageCode = "";
        try {
            String path = FileTransfer.copyFileToLocalDir((String)"/af/statguitoolkit/images", (String)imageName, (File)new File(System.getProperty("java.io.tmpdir"))).getAbsolutePath();
            path = path.replace("\\", "\\\\");
            imageCode = "<img src=\"file:///" + path + "\" >";
        }
        catch (IOException e) {
            logger.error((Object)"Error copying LaTeX/HTML-Image.");
            imageCode = label;
        }
        return this.textArea.makeButtonString(imageCode, al);
    }

    private void makeComponents() {
        this.textArea = new HTMLPaneWithButtons();
        this.doc = (DefaultStyledDocument)this.textArea.getDocument();
    }

    private void doTheLayout() {
        this.setLayout(new BoxLayout(this, 1));
        Box b = Box.createHorizontalBox();
        this.scrollPane = new JScrollPane((Component)this.textArea);
        b.add(this.scrollPane);
        this.add(b);
    }

    public void actionPerformed(ActionEvent e) {
    }

    public void setEditable(boolean b) {
        this.textArea.setEditable(b);
    }

    public void appendParagraph(String string) {
        this.textArea.appendParagraph(string);
    }
}

