% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combined.R
\name{test_combined}
\alias{test_combined}
\title{Combined test for equality of covariance matrices and correlation
matrices}
\usage{
test_combined(X, nv = NULL, repetitions = 1000)
}
\arguments{
\item{X}{a list or matrix containing the observation vectors.
In case of a list,each matrix in this list is another group, where the
observation vectors are the columns. For a matrix, all groups are together in
one matrix and nv is used to indicate the group sizes.}

\item{nv}{vector of group sizes}

\item{repetitions}{a scalar,  indicate the number of runs for the chosen
method. The predefined value is 1.000, and the number should not be
below 500.}
}
\value{
an object of the class \code{\link{CovTest}}.
}
\description{
For two groups a combined test for equality of covariance
matrices and equality of correlation matrices between these groups is
conducted. Both hypotheses can be rejected or only the larger one, the
equality of the covariance matrices
}
\examples{
# Load the data
data("EEGwide", package = "MANOVA.RM")

vars <- colnames(EEGwide)[1:6]

# Part the data into six groups of sex and diagnosis
X_list <- list(t(EEGwide[EEGwide$sex=="M" & EEGwide$diagnosis=="AD",vars]),
               t(EEGwide[EEGwide$sex=="M" & EEGwide$diagnosis=="MCI",vars]))

nv <- unlist(lapply(X_list, ncol))
set.seed(31415)
test_combined(X_list, nv)

}
