% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/renewal_methods.R
\name{chiSq_pearson}
\alias{chiSq_pearson}
\alias{chiSq_pearson.renewal}
\alias{chiSq_pearson.glm}
\title{Pearson Chi-Square test}
\usage{
chiSq_pearson(object, ...)

\method{chiSq_pearson}{renewal}(object, ...)

\method{chiSq_pearson}{glm}(object, ...)
}
\arguments{
\item{object}{an object from class \code{renewal}.}

\item{...}{currently not used.}
}
\value{
data.frame with 5 columns given the count values (\code{Counts}),
    observed frequencies (\code{Actual}), model's prediction
    (\code{Predicted}), the difference (\code{Diff}) and the contribution to
    the Pearson's statistic (\code{Pearson}).
}
\description{
Carry out Pearson Chi-Square test and compute the Pearson statistic.
}
\details{
The computation is inspired from Cameron(2013) Chapter 5.3.4. Observed and
fitted frequencies are computed and the contribution of every observed cell
to the Pearson's chi-square test statistic is reported. The idea is to check if
the fitted model has a tendancy to over or under predict some ranges of data
}
\references{
\insertRef{cameron2013regression}{Countr}
}
\seealso{
\code{\link{chiSq_gof}}
}
