% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copernicus_download_motu.r
\name{copernicus_download_motu}
\alias{copernicus_download_motu}
\title{Subset and download a specific marine product from Copernicus}
\usage{
copernicus_download_motu(
  username = getOption("CopernicusMarine_uid", ""),
  password = getOption("CopernicusMarine_pwd", ""),
  destination,
  product,
  layer,
  variable,
  output,
  region,
  timerange,
  verticalrange,
  sub_variables,
  overwrite = FALSE
)
}
\arguments{
\item{username}{Your Copernicus marine user name. Can be provided as \code{option(CopernicusMarine_uid = "my_user_name")},
or as argument here.}

\item{password}{Your Copernicus marine password. Can be provided as \code{option(CopernicusMarine_pwd = "my_password")},
or as argument here.}

\item{destination}{File or path where the requested file will be downloaded to.}

\item{product}{An identifier (type \code{character}) of the desired Copernicus marine product.
Can be obtained with \code{\link{copernicus_products_list}}.}

\item{layer}{The name of a desired layer within a product (type \code{character}). Can be obtained with \code{\link{copernicus_product_details}}.}

\item{variable}{The name of a desired variable in a specific layer of a product (type \code{character}).
Can be obtained with \code{\link{copernicus_product_details}}.}

\item{output}{File type for the output. \code{"netcdf"} will work in most cases.}

\item{region}{Specification of the bounding box as a \code{vector} of \code{numeric}s WGS84 lat and lon coordinates.
Should be in the order of: xmin, ymin, xmax, ymax.}

\item{timerange}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} A \code{vector} with two elements (lower and upper value)
for a requested time range. The \code{vector} should be coercible to \code{POSIXct}.}

\item{verticalrange}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} A \code{vector} with two elements (minimum and maximum)
numerical values for the depth of the vertical layers (if any).}

\item{sub_variables}{A \code{vector} of names of requested sub variables.}

\item{overwrite}{A \code{logical} value. When \code{FALSE} (default), files at the \code{destination} won't be
overwritten when the exist. Instead an error will be thrown if this is the case. When set to
\code{TRUE}, existing files will be overwritten.}
}
\value{
Returns a \code{logical} value invisibly indicating whether the requested file was
successfully stored at the \code{destination}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}} Subset and download a specific marine product from Copernicus.
This particular function uses the MOTU server for this purpose. You need to register an account
at \url{https://data.marine.copernicus.eu} before you can use this function.
}
\examples{
\dontrun{
destination <- tempfile("copernicus", fileext = ".nc")

## Assuming that Copernicus account details are provided as `option`
copernicus_download_motu(
  destination   = destination,
  product       = "GLOBAL_ANALYSISFORECAST_PHY_001_024",
  layer         = "cmems_mod_glo_phy-cur_anfc_0.083deg_P1D-m",
  variable      = "sea_water_velocity",
  output        = "netcdf",
  region        = c(-1, 50, 10, 55),
  timerange     = c("2021-01-01", "2021-01-02"),
  verticalrange = c(0, 2),
  sub_variables = c("uo", "vo")
)

mydata <- stars::read_stars(destination)

plot(mydata["vo"])
}
}
\author{
Pepijn de Vries
}
