% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cc_equ.R
\name{cc_equ}
\alias{cc_equ}
\title{Identify Records with Identical lat/lon}
\usage{
cc_equ(
  x,
  lon = "decimallongitude",
  lat = "decimallatitude",
  test = "absolute",
  value = "clean",
  verbose = TRUE
)
}
\arguments{
\item{x}{data.frame. Containing geographical coordinates and species
names.}

\item{lon}{character string. The column with the longitude coordinates.
Default = \dQuote{decimallongitude}.}

\item{lat}{character string. The column with the latitude coordinates.
Default = \dQuote{decimallatitude}.}

\item{test}{character string. Defines if coordinates are compared exactly
(\dQuote{identical}) or on the absolute scale (i.e. -1 = 1,
\dQuote{absolute}). Default is to \dQuote{absolute}.}

\item{value}{character string.  Defining the output value. See value.}

\item{verbose}{logical. If TRUE reports the name of the test and the number
of records flagged.}
}
\value{
Depending on the \sQuote{value} argument, either a \code{data.frame}
containing the records considered correct by the test (\dQuote{clean}) or a
logical vector (\dQuote{flagged}), with TRUE = test passed and FALSE = test failed/potentially
problematic . Default = \dQuote{clean}.
}
\description{
Removes or flags records with equal latitude and longitude coordinates, either exact or
absolute. Equal coordinates can often indicate data entry errors.
}
\examples{

x <- data.frame(species = letters[1:10], 
                decimallongitude = runif(100, -180, 180), 
                decimallatitude = runif(100, -90,90))

cc_equ(x)
cc_equ(x, value = "flagged")

}
\seealso{
Other Coordinates: 
\code{\link{cc_cap}()},
\code{\link{cc_cen}()},
\code{\link{cc_coun}()},
\code{\link{cc_dupl}()},
\code{\link{cc_gbif}()},
\code{\link{cc_inst}()},
\code{\link{cc_iucn}()},
\code{\link{cc_outl}()},
\code{\link{cc_sea}()},
\code{\link{cc_urb}()},
\code{\link{cc_val}()},
\code{\link{cc_zero}()}
}
\concept{Coordinates}
\keyword{Coordinate}
\keyword{cleaning}
