% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ReasonableSetConcept.R
\name{reasonableSetVertices}
\alias{reasonableSetVertices}
\title{Compute vertices of reasonable set}
\usage{
reasonableSetVertices(v)
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}
}
\value{
rows of the matrix are the vertices of the reasonable set
}
\description{
Calculates the vertices of the reasonable set for given game vector.
}
\examples{
library(CoopGame)
reasonableSetVertices(c(0,0,0,1,1,1,2))

\donttest{
library(CoopGame)
v <- c(0,0,0,3,3,3,6)
reasonableSetVertices(v)
#       [,1] [,2] [,3]
# [1,]    3    0    3
# [2,]    0    3    3
# [3,]    3    3    0
}

}
\references{
Milnor J.W. (1953) \emph{Reasonable Outcomes for N-person Games}, Rand Corporation, Research Memorandum RM 916.

Branzei R., Dimitrov D. and Tijs S. (2006) \emph{Models in cooperative game theory}, Springer, p. 21

Chakravarty S.R., Mitra M. and Sarkar P. (2015) \emph{A Course on Cooperative Game Theory}, Cambridge University Press, pp. 43--44

Gerard-Varet L.A. and Zamir S. (1987) "Remarks on the reasonable set of outcomes in a general coalition function form game", Int. Journal of Game Theory 16(2), pp. 123--143
}
\author{
Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
