% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BBconsensus2.R
\name{BBconsensus2}
\alias{BBconsensus2}
\title{Core function in computing consensus ranking as defined by Emond and Mason (2002)}
\usage{
BBconsensus2(RR, cij, Po, PS = TRUE, FULL = FALSE)
}
\arguments{
\item{RR}{A ranking}

\item{cij}{combined input matrix}

\item{Po}{current penalty}

\item{PS}{If PS=true, it prints the evaluating branches}

\item{FULL}{Default FULL=FALSE. If FULL=TRUE, the searching is limited to the space of complete rankings. FULL=TRUE if the function is called by BBFULL algorithm.}
}
\value{
median ranking
}
\description{
Core function in computing consensus ranking as defined by Emond and Mason (2002), recalled by EMCons function
}
\references{
Emond, E. J., and Mason, D. W. (2002). A new rank correlation coefficient with application to the consensus ranking problem. Journal of Multi-Criteria Decision Analysis, 11(1), 17-28.
#
D'Ambrosio, A., Amodio, S., and Iorio, C. (2015). Two algorithms for finding optimal solutions of the Kemeny rank aggregation problem for full rankings. Electronic Journal of Applied Statistical Analysis, 8(2), 198-213.
}
\seealso{
\code{\link{EMCons}} Emond and Mason branch-and-bound algorithm

\code{\link{BBFULL}} D'Ambrosio et al. branch-and-bound algorithm for full rankings
}
\author{
Antonio D'Ambrosio \email{antdambr@unina.it}
}
