% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DriverLGR.R
\name{DriverLGR}
\alias{DriverLGR}
\title{Assess potential driving factors of compound dry-hot events.}
\usage{
DriverLGR(Y,CI)
}
\arguments{
\item{Y}{Occurrence of compound dry-hot events (0-1 binary variable)}

\item{CI}{Climate index  as the driving factor of compound events (e.g., ENSO)}
}
\value{
slope parameter and associated p-value
}
\description{
Use the logistic regression model to establish relationships between
climate indices (e.g., ENSO) and occurrences of compound dry-hot events.
}
\examples{
CI=c(-0.7,-1.2,1.3,0.7,-0.6,1.1,-0.5,0.8,0.5,-0.5,1.6,-1.8,-0.5,-1.4,-0.1,2.2,-0.7,-1.1, 0.6, -1.7)
Y=c(0,0,1,1,0,0,0,0,0,0,1,0,1,0,0,1,0,0,0,0 )
res<-DriverLGR(Y,CI)
}
\references{
Hao, Z. et al. (2019). A monitoring and prediction system for compound dry and hot events. Environ. Res. Lett., 14:114034.
}
