/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import net.infonode.util.Direction;

public class LayoutUtil {
    private LayoutUtil() {
    }

    public static Component[] getVisibleChildren(Container container) {
        return LayoutUtil.getVisibleChildren(container.getComponents());
    }

    public static Component[] getVisibleChildren(Component[] componentArray) {
        int n = 0;
        for (int i = 0; i < componentArray.length; ++i) {
            if (!componentArray[i].isVisible()) continue;
            ++n;
        }
        Component[] componentArray2 = new Component[n];
        int n2 = 0;
        for (int i = 0; i < componentArray.length; ++i) {
            if (!componentArray[i].isVisible()) continue;
            componentArray2[n2++] = componentArray[i];
        }
        return componentArray2;
    }

    public static Rectangle getInteriorArea(Container container) {
        Insets insets = container.getInsets();
        return new Rectangle(insets.left, insets.top, container.getWidth() - insets.left - insets.right, container.getHeight() - insets.top - insets.bottom);
    }

    public static Dimension getInteriorSize(Container container) {
        Insets insets = container.getInsets();
        return new Dimension(container.getWidth() - insets.left - insets.right, container.getHeight() - insets.top - insets.bottom);
    }

    public static Dimension rotate(Dimension dimension, Direction direction) {
        return LayoutUtil.rotate(dimension, direction.isHorizontal());
    }

    public static Dimension rotate(Dimension dimension, boolean bl) {
        return dimension == null ? null : (bl ? dimension : new Dimension(dimension.height, dimension.width));
    }

    public static boolean isDescendingFrom(Component component, Component component2) {
        return component == component2 || component != null && LayoutUtil.isDescendingFrom(component.getParent(), component2);
    }

    public static Dimension getMaxMinimumSize(Component[] componentArray) {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < componentArray.length; ++i) {
            if (componentArray[i] == null) continue;
            Dimension dimension = componentArray[i].getMinimumSize();
            int n3 = dimension.width;
            int n4 = dimension.height;
            if (n2 < n4) {
                n2 = n4;
            }
            if (n >= n3) continue;
            n = n3;
        }
        return new Dimension(n, n2);
    }

    public static Dimension getMaxPreferredSize(Component[] componentArray) {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < componentArray.length; ++i) {
            if (componentArray[i] == null) continue;
            Dimension dimension = componentArray[i].getPreferredSize();
            int n3 = dimension.width;
            int n4 = dimension.height;
            if (n2 < n4) {
                n2 = n4;
            }
            if (n >= n3) continue;
            n = n3;
        }
        return new Dimension(n, n2);
    }

    public static Dimension getMinMaximumSize(Component[] componentArray) {
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MAX_VALUE;
        for (int i = 0; i < componentArray.length; ++i) {
            if (componentArray[i] == null) continue;
            Dimension dimension = componentArray[i].getMaximumSize();
            int n3 = dimension.width;
            int n4 = dimension.height;
            if (n > n3) {
                n = n3;
            }
            if (n2 <= n4) continue;
            n2 = n4;
        }
        return new Dimension(n, n2);
    }

    public static Insets rotate(Direction direction, Insets insets) {
        return direction == Direction.RIGHT ? insets : (direction == Direction.DOWN ? new Insets(insets.right, insets.top, insets.left, insets.bottom) : (direction == Direction.LEFT ? new Insets(insets.bottom, insets.right, insets.top, insets.left) : new Insets(insets.left, insets.bottom, insets.right, insets.top)));
    }

    public static Insets unrotate(Direction direction, Insets insets) {
        return direction == Direction.RIGHT ? insets : (direction == Direction.DOWN ? new Insets(insets.left, insets.bottom, insets.right, insets.top) : (direction == Direction.LEFT ? new Insets(insets.bottom, insets.right, insets.top, insets.left) : new Insets(insets.right, insets.top, insets.left, insets.bottom)));
    }

    public static Dimension add(Dimension dimension, Insets insets) {
        return new Dimension(dimension.width + insets.left + insets.right, dimension.height + insets.top + insets.bottom);
    }

    public static Dimension getValidSize(Dimension dimension, Component component) {
        Dimension dimension2 = component.getMinimumSize();
        Dimension dimension3 = component.getMaximumSize();
        return new Dimension(Math.max(dimension2.width, Math.min(dimension.width, dimension3.width)), Math.max(dimension2.height, Math.min(dimension.height, dimension3.height)));
    }

    public static Component getChildContaining(Component component, Component component2) {
        return component2 == null ? null : (component2.getParent() == component ? component2 : LayoutUtil.getChildContaining(component, component2.getParent()));
    }

    public static String getBorderLayoutOrientation(Direction direction) {
        return direction == Direction.UP ? "North" : (direction == Direction.DOWN ? "South" : (direction == Direction.LEFT ? "West" : "East"));
    }
}

