% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/age_shiny.R
\name{cus_result_gen}
\alias{cus_result_gen}
\title{Generate Customized Predicted Quantiles List}
\usage{
cus_result_gen(age_list, customized_q = 0.75, f)
}
\arguments{
\item{age_list}{A list containing all ROIs' true volumes, age trend estimates, and the fitted GAMLSS model.}

\item{customized_q}{A numeric value between 0 and 1 representing the quantile to predict (e.g., \code{0.75} for the 75th percentile).}

\item{f}{A string specifying the feature of interest within the \code{age_list}.}
}
\value{
A list containing the customized quantile value used for predictions and a data frame with columns for age, quantile type, prediction, and sex.
}
\description{
This function computes customized predicted quantiles for a specified feature across both female and male groups
using a GAMLSS model. The resulting list object is structured for visualization purposes.
}
\details{
This function utilizes the GAMLSS model to compute predictions for the specified quantile across demographic groups.
The results include predictions for both the specified quantile and the median, enabling enhanced visualization.
}
\examples{
sub_df <- age_df[,c("Volume_1", "age", "sex", "ICV_baseline")] |> na.omit()
colnames(sub_df) <- c("Volume_1", "age", "sex", "icv")
age_list <- list("Volume_1" = age_list_gen(sub_df = sub_df))
cus_result_gen(age_list, customized_q = 0.75, f = "Volume_1")
}
