% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/age_shiny.R
\name{age_list_gen}
\alias{age_list_gen}
\title{Age Trend Estimates Generation}
\usage{
age_list_gen(
  sub_df,
  lq = 0.25,
  hq = 0.75,
  mu = "smooth",
  sigma = "smooth",
  nu = "default",
  tau = "default"
)
}
\arguments{
\item{sub_df}{A four-column dataset that contains age, sex, intracranial volume (ICV) and roi volume related information.
The columns for age, sex, and ICV must be strictly named \code{"age"}, \code{"sex"}, and \code{"icv"}.}

\item{lq}{The lower bound quantile. eg: 0.25, 0.05}

\item{hq}{The upper bound quantile. eg: 0.75, 0.95}

\item{mu}{An indicator of whether to smooth age variable, include it as a linear term or only include the intercept in the mu formula.
"smooth": y ~ pb(age), "linear": y ~ age, "default": y ~ 1.}

\item{sigma}{An indicator of whether to smooth age variable, include it as a linear term or only include the intercept in the sigma formula.
"smooth": ~ pb(age), "linear": ~ age, "default": ~ 1.}

\item{nu}{An indicator of whether to smooth age variable, include it as a linear term or only include the intercept in the nu formula.
"smooth": ~ pb(age), "linear": ~ age, "default": ~ 1.}

\item{tau}{An indicator of whether to smooth age variable, include it as a linear term or only include the intercept in the tau formula.
"smooth": ~ pb(age), "linear": ~ age, "default": ~ 1.}
}
\value{
\code{age_list_gen} returns a list containing the following components:
\item{true_df}{a dataframe contains the true age and ROI volume information}
\item{predicted_df_sex}{a dataframe contains the estimated age trend adjusting sex and icv}
\item{model}{the fitted GAMLSS model}
}
\description{
A GAMLSS model using a Normal distribution was fitted separately to rois of interest,
to establish normative reference ranges for the volume of a specific ROI as a function of age,
adjusting for sex and intracranial volume.
}
\examples{
sub_df <- age_df[,c("Volume_1", "age", "sex", "ICV_baseline")] |> na.omit()
colnames(sub_df) <- c("Volume_1", "age", "sex", "icv")
age_list_gen(sub_df = sub_df)
}
