% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_lenCheck.R
\name{lenCheck}
\alias{lenCheck}
\title{Check each element of a list has expected length
 
Give a \code{list(a, b, ...)} and \code{vector(l1, l2, ...)}, 
check that length of a is equal to l1, length of b is equal to l2, etc.}
\usage{
lenCheck(ilist, ilengths)
}
\arguments{
\item{ilist}{list of items you want to check.}

\item{ilengths}{vector of lengths for these items.}
}
\value{
TRUE or a string
}
\description{
Check each element of a list has expected length
 
Give a \code{list(a, b, ...)} and \code{vector(l1, l2, ...)}, 
check that length of a is equal to l1, length of b is equal to l2, etc.
}
\examples{
\dontrun{
lenCheck(list(1, 2, 3), c(1, 1, 0))
grepl("\\\\nGiven: \\n.*", lenCheck(list(1, 2, 3), c(1, 1, 0)))
grepl("\\\\nGiven: \\n.*", lenCheck(list(1, c(1, 2, 3), list(4, 5, 6)), c(1, 1, 0))) 
lenCheck(list(1, c(1, 2, 3), list(4, 5, 6)), c(1, 3, 3))
}

}
\author{
Kaiyin Zhong, Fan Liu
}

