% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableCohortTiming.R
\name{tableCohortTiming}
\alias{tableCohortTiming}
\title{Format a summariseCohortTiming result into a visual table.}
\usage{
tableCohortTiming(
  result,
  timeScale = "days",
  uniqueCombinations = TRUE,
  type = "gt",
  header = visOmopResults::strataColumns(result),
  groupColumn = NULL,
  hide = "variable_level"
)
}
\arguments{
\item{result}{A summarised_result object. Output of summariseCohortTiming().}

\item{timeScale}{Time scale to plot results. Can be days or years.}

\item{uniqueCombinations}{Whether to restrict to unique reference and
comparator comparisons.}

\item{type}{Type of table. Check supported types with
\code{visOmopResults::tableType()}.}

\item{header}{Columns to use as header. See options with
\code{tidyColumns(result)}.}

\item{groupColumn}{Columns to group by. See options with
\code{tidyColumns(result)}.}

\item{hide}{Columns to hide from the visualisation. See options with
\code{tidyColumns(result)}.}
}
\value{
A formatted table of the summariseCohortTiming result.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
\dontrun{
library(CohortCharacteristics)
library(duckdb)
library(CDMConnector)
library(DrugUtilisation)

con <- dbConnect(duckdb(), eunomiaDir())
cdm <- cdmFromCon(con, cdmSchem = "main", writeSchema = "main")

cdm <- generateIngredientCohortSet(
  cdm = cdm,
  name = "my_cohort",
  ingredient = c("acetaminophen", "morphine", "warfarin")
)

timings <- summariseCohortTiming(cdm$my_cohort)

plotCohortTiming(
  timings,
  timeScale = "years",
  facet = c("cdm_name", "cohort_name_reference"),
  colour = c("cohort_name_comparator")
)

cdmDisconnect(cdm)
}

}
