% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluscata_kmeans.R
\name{cluscata_kmeans}
\alias{cluscata_kmeans}
\title{Compute the CLUSCATA partitionning algorithm on different blocks of binary variables from a CATA experiment. Can be performed using a multi start strategy or initial partition provided by the user}
\usage{
cluscata_kmeans(Data,nblo, clust, nstart=40, rho=0, NameBlocks=NULL, NameVar=NULL,
               Itermax=30, Graph_groups=TRUE, print_attempt=FALSE)
}
\arguments{
\item{Data}{data frame or matrix where the blocks of binary variables are merged horizontally. If you have a different format, see \code{\link{change_cata_format}}}

\item{nblo}{numerical. Number of blocks (subjects).}

\item{clust}{numerical vector or integer. Initial partition or number of starting partitions if integer. If numerical vector, the numbers must be 1,2,3,...,number of clusters}

\item{nstart}{numerical. Number of starting partitions. Default: 40}

\item{rho}{numerical between 0 and 1. Threshold for the noise cluster. If 0, there is no noise cluster. Default: 0}

\item{NameBlocks}{string vector. Name of each block. Length must be equal to the number of blocks. If NULL, the names are S1,...Sm. Default: NULL}

\item{NameVar}{string vector. Name of each variable (attribute, the same names for each subject). Length must be equal to the number of attributes. If NULL, the colnames of the first block are taken. Default: NULL}

\item{Itermax}{numerical. Maximum of iterations by partitionning algorithm. Default: 30}

\item{Graph_groups}{logical. Should each cluster compromise graphical representation be plotted? Default: TRUE}

\item{print_attempt}{logical. Print the number of remaining attempts in multi-start case? Default: FALSE}
}
\value{
a list with:
        \itemize{
         \item group: the clustering partition. If Noise_cluster=TRUE, some subjects could be in the noise cluster ("K+1")
         \item rho: the threshold for the noise cluster
         \item homogeneity: percentage of homogeneity of the subjects in each cluster and the overall homogeneity
         \item s_with_compromise: Similarity coefficient of each subject with its cluster compromise
         \item weights: weight associated with each subject in its cluster
         \item compromise: The compromise of each cluster
         \item CA: The correspondance analysis results on each cluster compromise (coordinates, contributions...)
         \item inertia: percentage of total variance explained by each axis of the CA for each cluster
         \item s_all_cluster: the similarity coefficient between each subject and each cluster compromise
         \item param: parameters called
         \item criterion: the CLUSCATA criterion error
         \item type: parameter passed to other functions
         }
}
\description{
Partitionning of binary Blocks from a CATA experiment. Each cluster is associated with a compromise
computed by the CATATIS method. Moreover, a noise cluster can be set up.
}
\examples{
data(straw)
cl_km=cluscata_kmeans(Data=straw[,1:(16*40)], nblo=40, clust=3)
plot(cl_km, Graph_groups=FALSE)
summary(cl_km)

}
\references{
Llobell, F., Cariou, V., Vigneau, E., Labenne, A., & Qannari, E. M. (2019). A new approach for the analysis of data and the clustering of subjects in a CATA experiment. Food Quality and Preference, 72, 31-39.
}
\seealso{
\code{\link{plot.cluscata}} , \code{\link{summary.cluscata}}, \code{\link{catatis}}, \code{\link{cluscata}}, \code{\link{change_cata_format}}
}
\keyword{CATA}
