% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster.assign.number.R
\name{cluster.assign.number}
\alias{cluster.assign.number}
\title{Number of clusters for each ellipsoid numbers}
\usage{
cluster.assign.number(
  data,
  Jmin = 3,
  Jmax = 35,
  level = 0.1,
  split.id = NULL,
  method = c("homogeneous-circular", "heterogeneous-circular", "ellipsoids", "general"),
  init = c("kmeans", "hierarchical"),
  additional.condition = TRUE,
  THRESHOLD = 1e-10,
  maxiter = 200,
  verbose = FALSE
)
}
\arguments{
\item{data}{n x d matrix of toroidal data on \eqn{[0, 2\pi)^d}
or \eqn{[-\pi, \pi)^d}}

\item{Jmin}{minimum number of ellipsoids. Default value is 3.}

\item{Jmax}{maximum number of ellipsoids. Default value is 35.}

\item{level}{a scalar between \eqn{[0,1]}. Default value
is 0.1.}

\item{split.id}{a n-dimensional vector consisting of values 1 (estimation)
and 2(evaluation)}

\item{method}{character which must be "homogeneous-circular",
"heterogeneous-circular", "ellipsoids", or "general".
 If "homogeneous-circular", the radii of k-spheres are identical.
 If "heterogeneous-circular", the radii of k-spheres may be different.
 If "ellipsoids", cluster with k-ellipsoids with initial parameters.
 If, "general", cluster with k-ellipsoids. The parameters to construct
 the ellipsoids are optimized with generalized Lloyd's algorithm, which is
 modified for toroidal space. To see the detail, consider the references.}

\item{init}{determine the initial parameter of "kmeans" method,
for option "general". Must be "kmeans" or "hierarchical".
If "kmeans", the initial parameters are obtained with extrinsic k-means
method.
If "hierarchical", the initial parameters are obtained with hierarchical
clustering method.
Default is "kmeans".}

\item{additional.condition}{boolean index.
If \code{TRUE}, a singular matrix will be altered to the scaled identity.}

\item{THRESHOLD}{number for difference between updating and
updated parameters. Default is 1e-10.}

\item{maxiter}{the maximal number of iteration. Default is 200.}

\item{verbose}{boolean index, which indicates whether display
additional details as to what the algorithm is doing or
how many loops are done. Moreover, if \code{additional.condition} is
\code{TRUE}, the warning message will also be reported.
Default is \code{FALSE}.}
}
\value{
an \code{output} object, containing a plot based on ggplot2,
  a \code{data.frame} for the number of clusters and \code{icp.torus} objects
  generated by given options, varied from \code{Jmin} to \code{Jmax}.
}
\description{
\code{cluster.assign.number} generates a table and a plot for the number of
  eliipsoids and the number of clusters, and a list of \code{icp.torus} objects
  which are used for k-means to k-ellipsoids clustering
}
\examples{
\donttest{
data <- ILE[1:200, 1:2]
cluster.assign.number(data, Jmin = 3, Jmax = 20, level = 0.1)
}
}
\references{
S. Jung, K. Park, and B. Kim (2021),
  "Clustering on the torus by conformal prediction"
}
\seealso{
\code{\link[ClusTorus]{icp.torus.score}}
}
