% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clump_profiles.R
\name{CluMP_profiles}
\alias{CluMP_profiles}
\title{Summary characteristics of identified clusters via CluMP}
\usage{
CluMP_profiles(CluMPoutput, cont_vars = NULL, cat_vars = NULL,
  show_NA = FALSE)
}
\arguments{
\item{CluMPoutput}{An object (output) from the \code{\link{CluMP}} function.}

\item{cont_vars}{An optional single character or a character vector of continuous variables' names (from the original dataset).}

\item{cat_vars}{An optional single character or a character vector of categorical variables' names (from the original dataset).}

\item{show_NA}{Logical scalar. Should be calculated and shown descriptive statistics for \emph{NA} cluster if exists? Default is \emph{FALSE}. \emph{NA} cluster gathers improper individuals (trajectories with < 3 not missing observations) for longitudinal clustering.}
}
\value{
Returns a \code{\link[base]{list}} with cluster variable (Y) summary, both baseline and changes; time and a summary of the number of observations (visits); clustering parameters summary and optional continuous variables summary (baseline and changes) and categorical variables summary (baseline and end).
}
\description{
The function CluMP_profiles provides a description (profile) for each cluster. The description is in the form of a summary list containing descriptive statistics of a cluster variable, time variable, cluster parameters and other variables (covariates), both continuous and categorical.
}
\examples{
dataMale <- GeneratePanel(n = 50, Param = ParamLinear, NbVisit = 10)
dataMale$Gender <- "M"
dataFemale <- GeneratePanel(n = 50, Param = ParamLinear, NbVisit = 10)
dataFemale$ID <- dataFemale$ID + 50
dataFemale$Gender <- "F"
data <- rbind(dataMale, dataFemale)

CLUMP3 <- CluMP(formula = Y ~ Time, group = "ID", data = data, cl_numb = 3)
CluMP_profiles(CLUMP3, cat_vars = "Gender")

}
\keyword{CluMP}
