% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MorphMatrix2PCoA.R
\name{MorphMatrix2PCoA}
\alias{MorphMatrix2PCoA}
\title{Principal Coordinates on a Cladistic Matrix}
\usage{
MorphMatrix2PCoA(CladisticMatrix, Distance = "MORD", GEDType = "Wills",
  TransformDistances = "arcsine_sqrt",
  DistPolymorphismBehaviour = "min.difference",
  DistUncertaintyBehaviour = "min.difference",
  DistInapplicableBehaviour = "missing", CharacterDependencies = NULL,
  Alpha = 0.5, correction = "cailliez", Tree = NULL,
  EstimateAllNodes = FALSE, EstimateTipValues = FALSE,
  InapplicablesAsMissing = FALSE,
  AncestralPolymorphismBehaviour = "equalp",
  AncestralUncertaintyBehaviour = "equalp", Threshold = 0.01)
}
\arguments{
\item{CladisticMatrix}{A vector of mode character representing the tip names for which an ancestor is sought.}

\item{Distance}{The distance method to use (one of "RED", "GED", "GC", or "MORD" - the default). See \link{MorphDistMatrix} for more details.}

\item{GEDType}{The type of GED use. Must be one of \code{"Legacy"}, \code{"Hybrid"}, or \code{"Wills"} (the default). See details for an explanation.}

\item{TransformDistances}{The transformation to apply to distances. See \link{MorphDistMatrix} for details.}

\item{DistPolymorphismBehaviour}{The distance behaviour for dealing with polymorphisms. Must be one of \code{"mean.difference"}, \code{"min.difference"} (the default), or \code{"random"}. See \link{MorphDistMatrix} for details.}

\item{DistUncertaintyBehaviour}{The distance behaviour for dealing with uncertainties. Must be one of \code{"mean.difference"}, \code{"min.difference"} (the default), or \code{"random"}. See \link{MorphDistMatrix} for details.}

\item{DistInapplicableBehaviour}{The behaviour for dealing with inapplicables. Must be one of \code{"missing"} (default), or \code{"HSJ"}. See \link{MorphDistMatrix} for details.}

\item{CharacterDependencies}{Only relevant if using \code{InapplicableBehaviour = "HSJ"}. Must be a two-column matrix with colnames "DependentCharacter" and "IndependentCharacter" that specifies character hierarchies. See \link{MorphDistMatrix} for details.}

\item{Alpha}{The alpha value (sensu Hopkins and St John 2018). Only relevant if using \code{InapplicableBehaviour = "HSJ"}. See \link{MorphDistMatrix} for details.}

\item{correction}{The negative eigenvalue correction to use (one of "lingoes", "none", or "cailliez" - the default). See \link{pcoa} for more details.}

\item{Tree}{If a phylmorphospace is desired then a tree with root age and branch-lengths must be included.}

\item{EstimateAllNodes}{If including a tree whether you want to estinate ancestral states for all characters (default is FALSE). See \link{AncStateEstMatrix} for more details.}

\item{EstimateTipValues}{If including a tree whether you want to estinate missing or polymorphic tip states (default is FALSE). See \link{AncStateEstMatrix} for more details.}

\item{InapplicablesAsMissing}{See \link{AncStateEstMatrix}.}

\item{AncestralPolymorphismBehaviour}{Behaviour for dealing with polymorphisms when producing ancestral state estimates - see \link{AncStateEstMatrix}.}

\item{AncestralUncertaintyBehaviour}{Behaviour for dealing with uncertainties when producing ancestral state estimates - see \link{AncStateEstMatrix}.}

\item{Threshold}{Threshold for ancestral state estimation of discrete characters - see \link{AncStateEstMatrix} for details.}
}
\value{
\item{Tree}{The tree (if supplied). Note this may be pruned from the input tree by \link{TrimMorphDistMatrix}.}

\item{DistMatrix}{The distance matrix. Note this may be pruned by \link{TrimMorphDistMatrix} and thus not include all taxa.}

\item{RemovedTaxa}{A vector of taxa (or nodes) removed by \link{TrimMorphDistMatrix}. Returns NULL if none are removed.}

\item{note}{See \link{pcoa}.}

\item{values}{See \link{pcoa}.}

\item{vectors}{See \link{pcoa}.}

\item{trace}{See \link{pcoa}.}

\item{vectors.cor}{See \link{pcoa}.}

\item{trace.cor}{See \link{pcoa}.}
}
\description{
Performs Principal Coordinates Analysis (PCoA) on a cladistic matrix.
}
\details{
Takes a cladistic matrix in the format imported by \link{ReadMorphNexus} and performs Principal Coordinates (Gower 1966) analysis on it.

This function is effectively a wrapper for \link{pcoa} from the \link{ape} package and the user is referred there for some of the options (e.g., using the Caillez 1983 approach to avoiding negative eigenvalues).

If providing a tree and inferring ancestral states then options to also infer missing or uncertain tips and whether to infer values for all characters at all internal nodes are provided (via \link{AncStateEstMatrix}).

Other options within the function concern the distance metric to use and the transformation to be used if selecting a propotional distance (see \link{MorphDistMatrix}).

IMPORTANT: The function can remove taxa (or if including a tree, nodes as well) if they lead to an incomplete distance matrix (see \link{TrimMorphDistMatrix}).
}
\examples{

# Run on Michaux (189) data set with defaults:
x <- MorphMatrix2PCoA(Michaux1989)

# Show output:
x

# Generate a (made up) tree:
Tree <- rtree(length(rownames(Michaux1989$Matrix_1$Matrix)))

# Add taxon names to it:
Tree$tip.label <- rownames(Michaux1989$Matrix_1$Matrix)

# Set root time by making youngest taxon extant:
Tree$root.time <- max(diag(vcv(Tree)))

# Run with tree:
y <- MorphMatrix2PCoA(Michaux1989, Tree = Tree)

# Show new output:
y

}
\references{
Cailliez, F., 1983. The analytical solution of the additive constant problem. Psychometrika, 48, 305-308.

Gower, J. C., 1966. Some distance properties of latent root and vector methods used in multivariate analysis. Biometrika, 53, 325-338.
}
\author{
Graeme T. Lloyd \email{graemetlloyd@gmail.com}
}
\keyword{classic}
\keyword{coordinates}
\keyword{multidimensional}
\keyword{principal}
\keyword{scaling,}
