% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv_pcaSpectra.R
\name{cv_pcaSpectra}
\alias{cv_pcaSpectra}
\title{Cross-Validation of Classical PCA Results for a Spectra Object}
\usage{
cv_pcaSpectra(spectra, pcs, choice = "noscale", repl = 50, segments = 4,
  segment.type = c("random", "consecutive", "interleaved"), length.seg,
  trace = FALSE, ...)
}
\arguments{
\item{spectra}{An object of S3 class \code{\link{Spectra}}.}

\item{pcs}{As per \code{\link[chemometrics]{pcaCV}} where it is called amax;
an integer giving the number of PC scores to include.}

\item{choice}{A character string indicating the choice of scaling.  One of
\code{c("noscale"}, \code{"autoscale"}, \code{"Pareto")}.}

\item{repl}{As per \code{\link[chemometrics]{pcaCV}}; the number of
replicates to perform.}

\item{segments}{As per \code{\link[chemometrics]{pcaCV}}.}

\item{segment.type}{As per \code{\link[chemometrics]{pcaCV}}.}

\item{length.seg}{As per \code{\link[chemometrics]{pcaCV}}.}

\item{trace}{As per \code{\link[chemometrics]{pcaCV}}.}

\item{\dots}{Parameters to be passed to the plotting routines.}
}
\value{
A list as described in \code{\link[chemometrics]{pcaCV}}, so the
result must be assigned or it will appear at the console.  Side effect is a
plot.
}
\description{
This function carries out classical PCA on the data in a
\code{\link{Spectra}} object using a cross-validation method.  A simple
re-write of Peter Filzmoser's \code{\link[chemometrics]{pcaCV}} method
with some small plotting changes.
}
\examples{

data(SrE.IR)
pca <- cv_pcaSpectra(SrE.IR, pcs = 5)

}
\references{
K. Varmuza and P. Filzmoser \emph{Introduction to Multivariate
Statistical Analysis in Chemometrics}, CRC Press, 2009.

\url{https://github.com/bryanhanson/ChemoSpec}\cr
}
\seealso{
\code{\link[chemometrics]{pcaCV}} for the underlying function.
}
\author{
Bryan A. Hanson, DePauw University. Derived from \code{\link[chemometrics]{pcaCV}}.
}
\keyword{multivariate}
