% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NlmeCovariateParameter.r
\name{removeCovariate}
\alias{removeCovariate}
\title{Remove covariate from structural parameters in a model object.}
\usage{
removeCovariate(.Object, covariate = NULL, paramName = NULL)
}
\arguments{
\item{.Object}{Model object}

\item{covariate}{Covariates to remove from model. If \code{NULL} all covariates will be removed from model.}

\item{paramName}{Structural parameters for which to remove covariate effect(s) from. If \code{NULL} covariate effect will be removed from all structural parameters.}
}
\value{
Modified \code{NlmePmlModel} object
}
\description{
Remove one or more covariates from structural parameters in a model object.
}
\examples{
model <- pkmodel(
  numCompartments = 2,
  data = pkData,
  ID = "Subject",
  Time = "Act_Time",
  A1 = "Amount",
  CObs = "Conc"
)

# Add Gender covariate of type categorical
model <- addCovariate(model,
  covariate = "Gender",
  type = "Categorical",
  effect = c("V2", "Cl2"),
  levels = c(0, 1),
  labels = c("Female", "Male")
)

# Add BodyWeight covariate of type continuous
model <- addCovariate(model,
  covariate = "BodyWeight",
  type = "Continuous",
  direction = "Backward",
  center = "Mean",
  effect = c("V", "Cl")
)

# Remove all covariates from model
model <- removeCovariate(model)

}
