% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/profile_estimation.r
\name{profilePertubate}
\alias{profilePertubate}
\title{Executes an NLME profile perturbation}
\usage{
profilePertubate(
  hostPlatform,
  params = NULL,
  profiles,
  model = NULL,
  sortColumns = SortColumns(""),
  scenarios = list(),
  runInBackground = FALSE
)
}
\arguments{
\item{hostPlatform}{How to execute the run(NlmeParallelHost)}

\item{params}{Engine parameters(NlmeEngineExtraParams)}

\item{profiles}{Profiles to perturbate(ProfileParameters)}

\item{model}{PK/PD model}

\item{sortColumns}{Optional list of columns to sort and fit(SortColumns)}

\item{scenarios}{Optional list of scenarios to fit(NlmeScenario)}

\item{runInBackground}{Set to \code{TRUE} to run in background and return prompt(Bool)}
}
\value{
List of results from NLME execution.
}
\description{
Executes an NLME profile perturbation
}
\examples{
\donttest{
# metod = 3 is FOCE-LB
 params <- NlmeEngineExtraParams(
   method = 3,
   numIterations = 1000
 )

 profile1 <- ProfileVar("tvV", 9.548, "-2,-1,0,1,2")
 profile2 <- ProfileVar("tvCl", 0.919, "-0.5,0,1.5")
 profiles <- ProfileParameters("USE_DELTA", c(profile1, profile2))

 job <- profilePertubate(defaultHost, params, profiles, model)
}
}
\keyword{internal}
