% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constrained.smoothspline.R
\name{constrained.smoothspline}
\alias{constrained.smoothspline}
\title{constrained.smoothspline}
\usage{
constrained.smoothspline(y, times, pen.degree, constraint = "fixed",
  derivative.values = NA, initial.value = NA, times.new,
  num.folds = "leave-one-out", lambda = "optim")
}
\arguments{
\item{y}{a vector of response variables.}

\item{times}{a vector of time points at which y was measured, same
length as y.}

\item{pen.degree}{desired degree of the derivative in smoothing
penalty.}

\item{constraint}{one of 'none', 'fixed' or 'bounded' depending on
whether the derivatives should not be constrained, fixed to a
constant or bounded in an interval, respectively.}

\item{derivative.values}{either a vector with the same length as y
if contraint=='fixed' or a matrix with 2 columns conatining the
lower and upper bounds on the derivatives if
contraint=='bounded'.}

\item{initial.value}{optional paramter that specifies an initial
value of the spline incase it should be fixed.}

\item{times.new}{optional vector of new time points at which the
spline should be evaluated.}

\item{num.folds}{either a numeric value of the number of folds or
the string "leave-one-out" for a leave one out type
cross-validation in determining the penalty parameter.}

\item{lambda}{either a numeric value if the penalty parameter is
fixed explicitely or one of the values 'optim' or 'grid.search'
depending on the desired optimization procedure.}
}
\value{
a list consisting of the following
  elements

\item{smooth.vals}{predicted values at points times}
\item{residual}{residuals}
\item{smooth.vals.new}{predicted values at time points times.new}
\item{smooth.deriv}{predicted derivative values at points times}
\item{pen.par}{penality parameter used for smoothing}
}
\description{
Fit a smoothing spline with constraints on derivatives
}
\details{
For further details see the references.
}
\examples{
## Example
x <- seq(0,4,length.out=200)
x.long <- seq(0,4,length.out=200)
y <- x^2+rnorm(200,0,2)
dy <- 2*x
dybdd <- cbind(dy-0.5,dy+0.5)
plot(x,y)

ptm <- proc.time()
fit <- constrained.smoothspline(y=y,
                                times=x,
                                pen.degree=2,
                                constraint="none",
                                derivative.values=NA,
                                times.new=x.long,
                                num.folds=5,
                                lambda="optim")
print(proc.time()-ptm)
fit2 <- smooth.spline(x,y)
lines(x.long,fit[[3]],col="blue")
lines(fit2, col="green")
lines(x.long, x.long^2, col="black")
}
\references{
Pfister, N., S. Bauer, J. Peters (2018).
Identifying Causal Structure in Large-Scale Kinetic Systems
ArXiv e-prints (arXiv:1810.11776).
}
\author{
Niklas Pfister, Stefan Bauer and Jonas Peters
}
