% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\encoding{UTF-8}
\name{catr_srs_values}
\alias{catr_srs_values}
\title{Reference SRS codes for \CRANpkg{CatastRo} APIs}
\format{
A \CRANpkg{tibble} with 16 rows and columns:
\describe{
\item{SRS}{Spatial Reference System (CRS) value, identified by the
corresponding EPSG code.}
\item{Description}{Description of the SRS/EPSG code.}
\item{ovc_service}{Logical. Is this code valid on OVC services?}
\item{wfs_service}{Logical. Is this code valid on INSPIRE WFS services?}
}
}
\description{
A \CRANpkg{tibble} including the valid SRS (also known as CRS) values that
may be used on each API service.
}
\details{
\tabular{rlll}{
   SRS \tab Description \tab ovc_service \tab wfs_service \cr
   3785 \tab Web Mercator \tab FALSE \tab TRUE \cr
   3857 \tab Web Mercator \tab FALSE \tab TRUE \cr
   4230 \tab Geográficas en ED 50 \tab TRUE \tab FALSE \cr
   4258 \tab Geográficas en ETRS89 \tab TRUE \tab TRUE \cr
   4326 \tab Geográficas en WGS 80 \tab TRUE \tab TRUE \cr
   23029 \tab UTM huso 29N en ED50 \tab TRUE \tab FALSE \cr
   23030 \tab UTM huso 30N en ED50 \tab TRUE \tab FALSE \cr
   23031 \tab UTM huso 31N en ED50 \tab TRUE \tab FALSE \cr
   25829 \tab UTM huso 29N en ETRS89 \tab TRUE \tab TRUE \cr
   25830 \tab UTM huso 30N en ETRS89 \tab TRUE \tab TRUE \cr
   25831 \tab UTM huso 31N en ETRS89 \tab TRUE \tab TRUE \cr
   32627 \tab UTM huso 27N en WGS 84 \tab TRUE \tab FALSE \cr
   32628 \tab UTM huso 28N en WGS 84 \tab TRUE \tab FALSE \cr
   32629 \tab UTM huso 29N en WGS 84 \tab TRUE \tab FALSE \cr
   32630 \tab UTM huso 30N en WGS 84 \tab TRUE \tab FALSE \cr
   32631 \tab UTM huso 31N en WGS 84 \tab TRUE \tab FALSE \cr
}
}
\examples{
data(catr_srs_values)

# OVC valid codes
library(dplyr)

catr_srs_values \%>\% filter(ovc_service == TRUE)

# WFS valid codes

catr_srs_values \%>\% filter(ovc_service == TRUE)
}
\references{
\itemize{
\item \href{https://ovc.catastro.meh.es/ovcservweb/ovcswlocalizacionrc/ovccoordenadas.asmx}{OVCCoordenadas}
\item \href{https://www.catastro.minhap.es/webinspire/index.html}{INSPIRE WFS Service}
}
}
\seealso{
Other databases: 
\code{\link{catr_atom_get_address_db_all}()},
\code{\link{catr_atom_get_buildings_db_all}()},
\code{\link{catr_atom_get_parcels_db_all}()},
\code{\link{catr_atom_search_munic}()}

Other INSPIRE WFS services:
\code{\link{catr_wfs_get_address_bbox}()},
\code{\link{catr_wfs_get_buildings_bbox}()},
\code{\link{catr_wfs_get_parcels_bbox}()}

OVCCoordenadas API:
\code{\link{catr_ovc_get_cpmrc}()},
\code{\link{catr_ovc_get_rccoor_distancia}()},
\code{\link{catr_ovc_get_rccoor}()}
}
\concept{OVCCoordenadas}
\concept{WFS}
\concept{databases}
