% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elliptic_F.R
\name{elliptic_F}
\alias{elliptic_F}
\title{Incomplete elliptic integral of the first kind}
\usage{
elliptic_F(phi, m, minerror = 2 * .Machine$double.eps)
}
\arguments{
\item{phi}{amplitude, real or complex number}

\item{m}{parameter, real or complex number}

\item{minerror}{the bound on the relative error passed to
\code{\link{Carlson_RF}}}
}
\value{
A complex number, the value of the incomplete elliptic integral
\ifelse{html}{\out{F(&phi;,m)}}{\eqn{F(\phi,m)}{F(phi,m)}}.
}
\description{
Evaluate the incomplete elliptic integral of the first kind.
}
\examples{
elliptic_F(1, 0.2)
gsl::ellint_F(1, sqrt(0.2))
}
