% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sequentialDesign.R
\docType{data}
\name{seqDesign.class}
\alias{seqDesign.class}
\title{A Reference Class to generate a better Model2 or Model4 \code{\link{model.class}} objects}
\format{An object of class \code{R6ClassGenerator} of length 24.}
\usage{
seqDesign.class
}
\description{
This class generates a new \code{\link{model.class}} for Model4 and Model2. Based on the previous
estimation of the Gaussian process in the function \code{\link{model}}, the design of experiments previously used
is improved according to [Damblin et al. 2018]. The aim is to reduce the
error produced by the initial estimation of the Gaussian process by fortifying the initial DOE. The method consists
in proposing new points based on the expectancy improvement criterion.

Fields should not be changed or manipulated by the user as they are updated internally
during the estimation process.
}
\section{Fields}{

\describe{
\item{\code{doe.init}}{the initial DOE used to fit the first Gaussian process}

\item{\code{GP.init}}{the initial Gaussian process generated in \code{\link{model}} function}

\item{\code{GP.new}}{the new Gaussian process fortified with the new design points}

\item{\code{p}}{the number of parameter}

\item{\code{md}}{the initial model}

\item{\code{md.new}}{the new model}

\item{\code{mdfit}}{the initial calibrated model}

\item{\code{mdfit.new}}{the new calibrated model}

\item{\code{X}}{the data set}

\item{\code{m}}{minimum of the sum of squares used in the algorithm}
}}

\references{
DAMBLIN, Guillaume, BARBILLON, Pierre, KELLER, Merlin, et al. Adaptive numerical designs for the
 calibration of computer codes. SIAM/ASA Journal on Uncertainty Quantification, 2018, vol. 6, no 1, p. 151-179.
}
\keyword{datasets}
