% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exports.R
\docType{methods}
\name{diag,Expression-method}
\alias{diag,Expression-method}
\alias{diag}
\title{Matrix Diagonal}
\usage{
\S4method{diag}{Expression}(x = 1, nrow, ncol)
}
\arguments{
\item{x}{An \linkS4class{Expression}, vector, or square matrix.}

\item{nrow, ncol}{(Optional) Dimensions for the result when \code{x} is not a matrix.}
}
\value{
An \linkS4class{Expression} representing the diagonal vector or matrix.
}
\description{
Extracts the diagonal from a matrix or makes a vector into a diagonal matrix.
}
\examples{
C <- Variable(3,3)
obj <- Maximize(C[1,3])
constraints <- list(diag(C) == 1, C[1,2] == 0.6, C[2,3] == -0.3, C == Semidef(3))
prob <- Problem(obj, constraints)
result <- solve(prob)
result$value
result$getValue(C)
}
