% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expressions.R
\docType{class}
\name{Expression-class}
\alias{Expression-class}
\alias{Expression}
\alias{value,Expression-method}
\alias{grad,Expression-method}
\alias{domain,Expression-method}
\alias{as.character,Expression-method}
\alias{name,Expression-method}
\alias{curvature,Expression-method}
\alias{is_constant,Expression-method}
\alias{is_affine,Expression-method}
\alias{is_convex,Expression-method}
\alias{is_concave,Expression-method}
\alias{is_dcp,Expression-method}
\alias{is_quadratic,Expression-method}
\alias{is_pwl,Expression-method}
\alias{is_zero,Expression-method}
\alias{is_positive,Expression-method}
\alias{is_negative,Expression-method}
\alias{size,Expression-method}
\alias{is_scalar,Expression-method}
\alias{is_vector,Expression-method}
\alias{is_matrix,Expression-method}
\alias{nrow,Expression-method}
\alias{ncol,Expression-method}
\title{The Expression class.}
\usage{
\S4method{value}{Expression}(object)

\S4method{grad}{Expression}(object)

\S4method{domain}{Expression}(object)

\S4method{as.character}{Expression}(x)

\S4method{name}{Expression}(object)

\S4method{curvature}{Expression}(object)

\S4method{is_constant}{Expression}(object)

\S4method{is_affine}{Expression}(object)

\S4method{is_convex}{Expression}(object)

\S4method{is_concave}{Expression}(object)

\S4method{is_dcp}{Expression}(object)

\S4method{is_quadratic}{Expression}(object)

\S4method{is_pwl}{Expression}(object)

\S4method{is_zero}{Expression}(object)

\S4method{is_positive}{Expression}(object)

\S4method{is_negative}{Expression}(object)

\S4method{size}{Expression}(object)

\S4method{is_scalar}{Expression}(object)

\S4method{is_vector}{Expression}(object)

\S4method{is_matrix}{Expression}(object)

\S4method{nrow}{Expression}(x)

\S4method{ncol}{Expression}(x)
}
\arguments{
\item{x, object}{An \linkS4class{Expression} object.}
}
\description{
This class represents a mathematical expression.
}
\section{Methods (by generic)}{
\itemize{
\item \code{value}: The value of the expression.

\item \code{grad}: The (sub/super)-gradient of the expression with respect to each variable.

\item \code{domain}: A list of constraints describing the closure of the region where the expression is finite.

\item \code{name}: The string representation of the expression.

\item \code{curvature}: The curvature of the expression.

\item \code{is_constant}: The expression is constant if it contains no variables or is identically zero.

\item \code{is_affine}: The expression is affine if it is constant or both convex and concave.

\item \code{is_convex}: A logical value indicating whether the expression is convex.

\item \code{is_concave}: A logical value indicating whether the expression is concave.

\item \code{is_dcp}: The expression is DCP if it is convex or concave.

\item \code{is_quadratic}: A logical value indicating whether the expression is quadratic.

\item \code{is_pwl}: A logical value indicating whether the expression is piecewise linear.

\item \code{is_zero}: The expression is zero if it is both positive and negative.

\item \code{is_positive}: A logical value indicating whether the expression is positive.

\item \code{is_negative}: A logical value indicating whether the expression is negative.

\item \code{size}: The \code{c(row, col)} dimensions of the expression.

\item \code{is_scalar}: The expression is scalar if rows = cols = 1.

\item \code{is_vector}: The expression is a vector if min(rows, cols) = 1.

\item \code{is_matrix}: The expression is a matrix if rows > 1 and cols > 1.

\item \code{nrow}: Number of rows in the expression.

\item \code{ncol}: Number of columns in the expression.
}}

