% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics.R
\name{empcopula}
\alias{empcopula}
\title{Plot empirical copula}
\usage{
empcopula(ctre, OCTRE = FALSE, ...)
}
\arguments{
\item{ctre}{A \code{\link{ctre}} object}

\item{OCTRE}{Shall each magnitude be matched with the preceding interarrival
time (FALSE) or the succeeding interarrival time (TRUE)?}

\item{...}{Additional plotting arguments}
}
\description{
Plots the ranks of the magnitudes against the ranks of the preceding
(or succeeding) interarrival times.
}
\examples{
  library(magrittr)
  flares \%>\% ctre() \%>\% thin(k = 300) \%>\% empcopula(pch = '*')
}
