% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_helper.r
\name{lm.ols.refit}
\alias{lm.ols.refit}
\title{Get the ordinary least square estimated coefficients on a set of previously selected covariates}
\usage{
lm.ols.refit(X, Y, intercept, est.betas, log.level = NULL)
}
\arguments{
\item{X}{covariates (n times p matrix, n: number of entries, p: number of covariates)}

\item{Y}{response (vector with n entries)}

\item{intercept}{TRUE to fit the data with an intercept, FALSE to fit the data without an intercept}

\item{est.betas}{estimated betas from previous fitted result. It can be a vector with p+1 entries (first entry as intercept) or a matrix with p+1 columns. Non-zero coefficient means the corresponding covariate is selected}

\item{log.level}{log level to set. Default is NULL, which means no change in log level. See the function CSUV::set.log.level for more details}
}
\value{
a list of estimated coefficients
}
\description{
Get the ordinary least square estimated coefficients on a set of previously selected covariates
}
\examples{
X = matrix(rnorm(1000), nrow = 100)
Y = rowSums(X[,1:3])+rnorm(100)
est.beta = rep(0, 11)
est.beta[2:5] = 1
ols.mod = lm.ols.refit(X, Y, intercept = FALSE, est.betas = est.beta)
print(ols.mod$est.b)
}
