% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AnalogsPred_train.R
\name{training_analogs}
\alias{training_analogs}
\title{AEMET Training   
Training method (pre-downscaling) based on analogs: 
synoptic situations and significant predictors.}
\usage{
training_analogs(
  pred,
  slp_ext,
  lon,
  lat,
  slp_lon,
  slp_lat,
  var,
  HR_path,
  tdates
)
}
\arguments{
\item{pred}{List of matrix reanalysis data in a synoptic domain. The list 
has to contain reanalysis atmospheric variables (instantaneous 12h data) 
that must be indentify by parenthesis name.
For precipitation:
- u component of wind at 500 hPa (u500) in m/s 
- v component of wind at 500 hPa (v500) in m/s
- temperature at 500 hPa (t500) in K
- temperature at 850 hPa (t850) in K
- temperature at 1000 hPa (t1000) in K
- geopotential height at 500 hPa (z500) in m
- geopotential height at 1000 hPa (z1000) in m
- sea level pressure (slp) in hPa
- specific humidity at 700 hPa (q700) in g/kg
For maximum and minimum temperature:
- temperature at 1000 hPa (t1000) in K
- sea level pressure (slp) in hPa
All matrix must have [time,gridpoint] dimensions.
(time = number of training days, gridpoint = number of synoptic gridpoints).}

\item{slp_ext}{Matrix with atmospheric reanalysis sea level pressure
(instantaneous 12h data)(hPa). It has the same resolution as 'pred' parameter 
but with an extended domain. This domain contains extra degrees (most in the 
north and west part) compare to synoptic domain. The matrix must have 
[time,gridpoint] dimensions.
(time = number of training days, gridpoint = number of extended gridpoints).}

\item{lon}{Vector of the synoptic longitude (from (-180º) to 180º), 
The vector must go from west to east.}

\item{lat}{Vector of the synoptic latitude. The vector must go from north to south.}

\item{slp_lon}{Vector of the extended longitude (from (-180º) to 180º)
The vector must go from west to east.}

\item{slp_lat}{Vector of the extended latitude. The vector must go from north to south.}

\item{var}{Variable name to downscale. There are two options: 'prec' for
precipitation and 'temp' for maximum and minimum temperature.}

\item{HR_path}{Local path of HR observational files (maestro and pcp/tmx-tmn). 
For precipitation can be downloaded from http://www.aemet.es/documentos/es/serviciosclimaticos/cambio_climat/datos_diarios/dato_observacional/rejilla_5km/v2/Serie_AEMET_v2_pcp_1951a202006_txt.tar.gz
For maximum and minimum temperature can be downloaded from http://www.aemet.es/documentos/es/serviciosclimaticos/cambio_climat/datos_diarios/dato_observacional/rejilla_5km/temperatura/v1/tmax/Serie_AEMET_v1_tmax_1951a202006_txt.tar.gz and http://www.aemet.es/documentos/es/serviciosclimaticos/cambio_climat/datos_diarios/dato_observacional/rejilla_5km/temperatura/v1/tmin/Serie_AEMET_v1_tmin_1951a202006_txt.tar.gz respetively.
Maestro file (maestro_red_hr_SPAIN.txt) has gridpoint (nptos), longitude (lon), latitude (lat) and 
altitude (alt) in columns (vector structure).
Data file (pcp/tmx/tmn_red_SPAIN_1951-201903.txt) includes 5km resolution spanish daily data 
(precipitation or maximum and minimum temperature from january 1951 to june 2020. See README 
file for more information.
IMPORTANT!: HR observational period must be the same as for reanalysis variables.
It is assumed that the training period is smaller than the HR original one (1951-2020), so it is 
needed to make a new ascii file with the new period and the same structure as original, 
specifying the training dates ('tdates' parameter) in the name 
(e.g. 'pcp_red_SPAIN_19810101-19961231.txt' for '19810101-19961231' period).}

\item{tdates}{Training period dates in format YYYYMMDD(start)-YYYYMMDD(end) (e.g. 19810101-19961231).}
}
\value{
matrix list (e.g. restrain) as a result of characterize the past synoptic 
situations and the significant predictors needed to downscale seasonal forecast variables. 
For precipitation the output includes:
um: u component of geostrophic wind in all period (numeric matrix with [time,gridpoint] dimensions) 
vm: v component of geostrophic wind in all period (numeric matrix with [time,gridpoint] dimensions) 
nger: number of synoptic situations (integer)  
gu92: u component of geostrophic wind for each synoptic situation (numeric matrix with 
      [nger,gridpoint] dimensions)
gv92: v component of geostrophic wind for each synoptic situation (numeric matrix with
      [nger,gridpoint] dimensions)
gu52: u component of wind at 500 hPa for each synotic situation (numeric matrix with
      [nger,gridpoint] dimensions)
gv52: v component of wind at 500 hPa for each synotic situation (numeric matrix with
      [nger,gridpoint] dimensions)
neni: number of reference centers where predictors are calculated (integer)
vdmin: minimum distances between each HR gridpoint and the four nearest synoptic 
       gridpoints (numeric matrix with [nptos,4] dimensions) (nptos = number of HR gridpoints)
vref: four nearest synoptic gridpoints to each HR gridpoint (integer matrix with 
      [nptos,4] dimensions) 
ccm: multiple correlation coeficients (numeric matrix with [nger,nptos] dimensions)
indices: 
        - lab_pred: numeric labels of selected predictors (integer matrix 
                    with [nger,nptos,11,1] dimensions) 
        - cor_pred: partial correlation of selected predictors (numeric matrix with 
                    [nger,nptos,11,2] dimensions) 
For maximum and minimum temperature the output includes:
um: u component of geostrophic wind in all training period (numeric matrix with [time,gridpoint] dimensions) 
vm: v component of geostrophic wind in all training period (numeric matrix with [time,gridpoint] dimensions) 
insol: insolation in all training period (numeric vector with [time] dimension)
neni: number of reference centers where predictors are calculated (integer)
vdmin: minimum distances between each HR gridpoint and the four nearest synoptic 
       gridpoints (numeric matrix with [nptos,4] dimensions) (nptos = number of HR gridpoints)
vref: four nearest synoptic gridpoints to each HR gridpoint (integer matrix with 
      [nptos,4] dimensions) 

The output can directly use as argument to 'CST_AnalogsPredictors' function 
(e.g. resdowns <- CST_AnalogsPredictors(...,restrain))
}
\description{
This function caracterizes the synoptic situations in a past period based on 
low resolution reanalysis data (e.g, ERAInterim 1.5º x 1.5º) and an observational high 
resolution (HR) dataset (AEMET 5 km gridded daily precipitation and maximum and 
minimum temperature) (Peral et al., 2017)). 
The method uses three domains: 
- peninsular Spain and Balearic Islands domain (5 km resolution): HR domain
- synoptic domain (low resolution): it should be centered over Iberian Peninsula and 
  cover enough extension to detect as much synoptic situations as possible.  
- extended domain (low resolution): it is an extension of the synoptic 
  domain. It is used for 'slp_ext' parameter (see 'slp_lon' and 'slp_lat' below).
}
\author{
Marta Dominguez Alonso - AEMET, \email{mdomingueza@aemet.es}

Nuria Perez-Zanon - BSC, \email{nuria.perez@bsc.es}
}
